﻿using Newtonsoft.Json;
using System;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using Windows.UI.Xaml.Controls;
using Windows.Web.Http.Filters;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace OpenDataSample
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        private string APIKey = "093d00ff-8d63-48be-8587-4d6d20157f98";
        public MainPage()
        {
            this.InitializeComponent();
            DataContext = new ViewModel();

            InitStopPoints();
        }

        private async void InitStopPoints()
        {
            using (var httpFilter = new HttpBaseProtocolFilter())
            {
                using (var httpClient = new HttpClient())
                {
                    // la clé d'API que nous avons reçu par mail encodé en base64
                    byte[] byt = System.Text.Encoding.UTF8.GetBytes(string.Format("{0}:", APIKey));
                    string password = Convert.ToBase64String(byt);

                    // ajout du header
                    httpClient.DefaultRequestHeaders.Add("Authorization", string.Format("Basic {0}", password));

                    // endpoint de l'API
                    HttpResponseMessage response = await httpClient.GetAsync("https://api.sncf.com/v1/coverage/sncf/places?q=gare");
                    if (response.StatusCode == HttpStatusCode.OK)
                    {
                        var responseAsString = await response.Content.ReadAsStringAsync();

                        // récupération de la liste des gares
                        var handler = JsonConvert.DeserializeObject<StopPointsHandler>(responseAsString);

                        // mise à jour du modèle
                        ((ViewModel)DataContext).StopPoints.Clear();
                        foreach (var item in handler.places)
                        {
                            ((ViewModel)DataContext).StopPoints.Add(item);
                        }

                    }
                }
            }
        }

        private async void GetJourney()
        {
            using (var httpFilter = new HttpBaseProtocolFilter())
            {
                using (var httpClient = new HttpClient())
                {
                    // la clé d'API que nous avons reçu par mail encodé en base64
                    byte[] byt = System.Text.Encoding.UTF8.GetBytes(string.Format("{0}:", APIKey));
                    string password = Convert.ToBase64String(byt);

                    // ajout du header
                    httpClient.DefaultRequestHeaders.Add("Authorization", string.Format("Basic {0}", password));

                    // endpoint de l'API
                    HttpResponseMessage response = await httpClient.GetAsync(
                        string.Format(
                            "https://api.sncf.com/v1/coverage/sncf/journeys?from={0}&to={1}&datetime={2}",
                            ((StopPoint)StartPoints.SelectedValue).id,
                            ((StopPoint)EndPoints.SelectedValue).id,
                            DateTime.Now.ToString("yyyyMMddTHHmmss")
                        )
                    );

                    if (response.StatusCode == HttpStatusCode.OK)
                    {
                        var responseAsString = await response.Content.ReadAsStringAsync();

                        // récupération de la liste des gares
                        var handler = JsonConvert.DeserializeObject<JourneyHandler>(responseAsString);

                        // mise à jour du modèle
                        ((ViewModel)DataContext).JourneySections.Clear();

                        // par défaut, affichage du premier trajet possible
                        if (handler.journeys.Count > 0)
                        {
                            foreach (var item in handler.journeys[0].Sections)
                            {
                                ((ViewModel)DataContext).JourneySections.Add(item);
                            }
                        }
                    }
                }
            }
        }

        private void StartJourney_Click(object sender, Windows.UI.Xaml.RoutedEventArgs e)
        {
            GetJourney();
        }
    }
}
