using System;
using System.Collections.Generic;
using System.ComponentModel;
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using W3C.Soap;
using Microsoft.Dss.Services.DefaultTarget;

namespace MotionDetector
{
    /// <summary>
    /// MotionDetector contract class
    /// </summary>
    public sealed class Contract
    {
        /// <summary>
        /// DSS contract identifer for MotionDetector
        /// </summary>
        [DataMember]
        public const string Identifier = "http://schemas.tempuri.org/2010/05/motiondetector.html";
    }

    /// <summary>
    /// MotionDetector state
    /// </summary>
    [DataContract]
    public class MotionDetectorState
    {
        [DataMember]
        public bool Enabled;

        [DataMember]
        public bool MotionDetected;
        [DataMember]
        public int MotionSize;
        [DataMember]
        public int XMotion;
        [DataMember]
        public int YMotion;

        [DataMember]
        public int MotionFrameWidth;

        [DataMember]
        public int MotionFrameHeight;

        [DataMember]
        public byte[] MotionFrame;

        public byte[] previousFrame;
    }

    [DataContract]
    public class DisableRequest { }

    [DataContract]
    public class EnableRequest { }

    public class Disable : Update<DisableRequest, PortSet<DefaultUpdateResponseType, Fault>>
    { }

    public class Enable : Update<EnableRequest, PortSet<DefaultUpdateResponseType, Fault>>
    { }

    /// <summary>
    /// MotionDetector main operations port
    /// </summary>
    [ServicePort]
    public class MotionDetectorOperations : PortSet<DsspDefaultLookup, DsspDefaultDrop, Get, Subscribe, MotionFrameAvailable, Disable, Enable>
    {
    }

    /// <summary>
    /// MotionDetector get operation
    /// </summary>
    public class Get : Get<GetRequestType, PortSet<MotionDetectorState, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        public Get()
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        public Get(GetRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Get(GetRequestType body, PortSet<MotionDetectorState, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }

    /// <summary>
    /// MotionDetector subscribe operation
    /// </summary>
    public class Subscribe : Subscribe<SubscribeRequestType, PortSet<SubscribeResponseType, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        public Subscribe()
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        public Subscribe(SubscribeRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Subscribe(SubscribeRequestType body, PortSet<SubscribeResponseType, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }

    [DataContract]
    public class MotionFrameAvailableRequest
    { }

    public class MotionFrameAvailable : Update<MotionFrameAvailableRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
        public MotionFrameAvailable()
            : base(new MotionFrameAvailableRequest())
        { }
    }
}


