using System;
using System.Collections.Generic;
using System.ComponentModel;
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using W3C.Soap;
using Microsoft.Dss.Services.DefaultTarget;

namespace PanTiltCamControl
{
    /// <summary>
    /// PanTiltCamControl contract class
    /// </summary>
    public sealed class Contract
    {
        /// <summary>
        /// DSS contract identifer for PanTiltCamControl
        /// </summary>
        [DataMember]
        public const string Identifier = "http://schemas.tempuri.org/2010/04/pantiltcamcontrol.html";
    }

    
    /// <summary>
    /// PanTiltCamControl state
    /// </summary>
    [DataContract]
    public class PanTiltCamControlState
    {
        [DataMember]
        public int CameraHandle;
    }

    public enum PanTiltMovement
    {
        PanLeft,
        PanRight,
        TiltUp,
        TiltDown,
        ResetPOV
    }


    [DataContract]
    public class PanTiltRequest
    {
        [DataMember]
        public PanTiltMovement Move;

        public PanTiltRequest()
        { }

        public PanTiltRequest(PanTiltMovement _move)
        {
            Move = _move;
        }
    }

    public class PanTilt : Update<PanTiltRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
        public PanTilt()
            : base(new PanTiltRequest())
        { }

        public PanTilt(PanTiltMovement _move)
            : base(new PanTiltRequest(_move))
        { }
    }


    /// <summary>
    /// PanTiltCamControl main operations port
    /// </summary>
    [ServicePort]
    public class PanTiltCamControlOperations : PortSet<DsspDefaultLookup, DsspDefaultDrop, Get, Subscribe, PanTilt>
    {
    }

    /// <summary>
    /// PanTiltCamControl get operation
    /// </summary>
    public class Get : Get<GetRequestType, PortSet<PanTiltCamControlState, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        public Get()
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        public Get(GetRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Get(GetRequestType body, PortSet<PanTiltCamControlState, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }

    /// <summary>
    /// PanTiltCamControl subscribe operation
    /// </summary>
    public class Subscribe : Subscribe<SubscribeRequestType, PortSet<SubscribeResponseType, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        public Subscribe()
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        public Subscribe(SubscribeRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Subscribe(SubscribeRequestType body, PortSet<SubscribeResponseType, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }
}


