﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;


namespace PanTiltCamGUI
{
    /// <summary>
    /// Interaction logic for PanTiltCamGUI.xaml
    /// </summary>
    public partial class PanTiltCamGUI : Window
    {
        public BitmapImage FrameSource;
        public BitmapImage MotionFrameSource;

        PanTiltCamGUIService _service;

        public PanTiltCamGUI()
        {
            InitializeComponent();
        }

        internal PanTiltCamGUI(PanTiltCamGUIService service) : this()
        {
            _service = service;
        }

        /// <summary>
        /// Displays a fault message
        /// </summary>
        /// <param name="fault">fault</param>
        internal void ShowFault(W3C.Soap.Fault fault)
        {
            var error = "Erreur!";

            if (fault.Reason != null && fault.Reason.Length > 0 && !string.IsNullOrEmpty(fault.Reason[0].Value))
            {
                error = fault.Reason[0].Value;
            }

            MessageBox.Show(
                this,
                error,
                Title,
                MessageBoxButton.OK,
                MessageBoxImage.Error);
        }

        private void btnUp_Click(object sender, RoutedEventArgs e)
        {
            _service.Button_Click("up");
        }

        private void btnDown_Click(object sender, RoutedEventArgs e)
        {
            _service.Button_Click("down");
        }

        private void btnLeft_Click(object sender, RoutedEventArgs e)
        {
            _service.Button_Click("left");
        }

        private void btnRight_Click(object sender, RoutedEventArgs e)
        {
            _service.Button_Click("right");
        }

        private void btnReset_Click(object sender, RoutedEventArgs e)
        {
            _service.Button_Click("reset");
        }

        private void btnToggleMotionDetection_Click(object sender, RoutedEventArgs e)
        {
            if ((string)btnToggleMotionDetection.Content == "Enable")
            {
                btnToggleMotionDetection.Content = "Disable";
                _service.ToggleMotionDetection("EnableMotionDetection");
            }
            else
            {
                btnToggleMotionDetection.Content = "Enable";
                _service.ToggleMotionDetection("DisableMotionDetection");
            }
            
        }


        

    }
}
