using System;

namespace DemoObserverDelegate
{

    class Menace : EventArgs
    {
        public Menace(string id, int x, int y)
        {
            this.id = id;
            this.x = x;
            this.y = y;
        }
        public String id;
        public int x;
        public int y;
    }

    class QuartierGeneral
    {
        public delegate void MenaceEventHandler(
            Object source, Menace m);
        public event MenaceEventHandler OnMenaceEventHandler;


        public void NotifyObservers()
        {
            Menace m = new Menace("Artillerie", 10, 10);
            if (OnMenaceEventHandler != null)
                OnMenaceEventHandler(this, m);
            
        }
    }

    class Soldat
    {
        private QuartierGeneral qg;
        public Soldat(QuartierGeneral qg)
        {
            this.qg = qg;
            /* Vieille syntaxe C# 1.0
            qg.OnMenaceEventHandler
                += new QuartierGeneral.MenaceEventHandler(
                    OnMenaceEvent);
             */
            // Syntaxe C# 2.0: infrence
            // du type du dlgu
            qg.OnMenaceEventHandler += OnMenaceEvent;
        }
        public void OnMenaceEvent(object source, Menace m)
        {
            Console.WriteLine("Soldat:");
            Console.WriteLine(m.id + " en vue");
            Console.WriteLine("Je me cache\n");
        }
    }

    class SousMarin
    {
        private QuartierGeneral qg;
        public SousMarin(QuartierGeneral qg)
        {
            this.qg = qg;
            qg.OnMenaceEventHandler += OnMenaceEvent;
        }
        public void OnMenaceEvent(object source, Menace m)
        {
            Console.WriteLine("Sous-Marin:");
            Console.WriteLine(m.id + " en vue");
            Console.WriteLine("Je plonge\n");
        }
        public void destruction()
        {
            Console.WriteLine("Sous-Marin detruit\n");
            qg.OnMenaceEventHandler -= OnMenaceEvent;            
        }
    }

    class Avion
    {
        private QuartierGeneral qg;
        public Avion(QuartierGeneral qg)
        {
            this.qg = qg;
            qg.OnMenaceEventHandler += OnMenaceEvent;
        }

        public void OnMenaceEvent(object source, Menace m)
        {
            Console.WriteLine("Avion:");
            Console.WriteLine(m.id + " en vue");
            Console.WriteLine("J'attaque\n");
        }
    }

    class Jeu
    {
        static void Main(string[] args)
        {
            QuartierGeneral qg = new QuartierGeneral();
            Soldat s = new Soldat(qg);
            SousMarin sm = new SousMarin(qg);
            Avion a = new Avion(qg);

            qg.NotifyObservers();
            Console.WriteLine("Simulation destruction sous-marin");
            sm.destruction();
            qg.NotifyObservers();

        }
    }
}
