using System;
using System.Collections.Generic;
using System.Text;

namespace DemoObserver
{
    interface IObservable
    {
        void Register(IObserver o);
        void UnRegister(IObserver o);
        void NotifyObservers();
    }

    interface IObserver {
        void Update(Menace m);
    }

    class Menace {
        public Menace(string id, int x, int y) {
        this.id = id;
        this.x = x;
        this.y = y;
    }
    public String id;
    public int x;
    public int y;
    }

    class QuartierGeneral : IObservable {
        private List<IObserver> observers = new List<IObserver>();
    public void Register(IObserver obs) {
        observers.Add(obs);
    }
    public void UnRegister(IObserver obs) {
            observers.Remove(obs);
    }
    public void NotifyObservers() {
        Menace m = new Menace("Artillerie", 10, 10);
        foreach(IObserver obs in observers)
        obs.Update(m);
    }
}

class Soldat : IObserver {
  private QuartierGeneral qg;
  public Soldat(QuartierGeneral qg) {
    this.qg = qg;
    qg.Register(this);
  }
  public void Update(Menace m) {
   Console.WriteLine("Soldat:");
   Console.WriteLine(m.id + " en vue");
   Console.WriteLine("Je me cache\n");
  }
}

class SousMarin : IObserver {
  private QuartierGeneral qg;
  public SousMarin(QuartierGeneral qg) {
    this.qg = qg;
    qg.Register(this);
  }
  public void Update(Menace m) {
    Console.WriteLine("Sous-Marin:");
    Console.WriteLine(m.id + " en vue");
    Console.WriteLine("Je plonge\n");
  }
  public void destruction() {
    Console.WriteLine("Sous-Marin detruit\n");
    qg.UnRegister(this);
  }
}

class Avion : IObserver {
  private QuartierGeneral qg;
  public Avion(QuartierGeneral qg) {
    this.qg = qg;
    qg.Register(this);
  }
  
  public void Update(Menace m) {
    Console.WriteLine("Avion:");
    Console.WriteLine(m.id + " en vue");
    Console.WriteLine("J'attaque\n");
  }
}

    class Jeu
    {
        static void Main(string[] args)
        {
            QuartierGeneral qg = new QuartierGeneral();
            Soldat s = new Soldat(qg);
            SousMarin sm = new SousMarin(qg);
            Avion a = new Avion(qg);

            qg.NotifyObservers();
            Console.WriteLine("Simulation destruction sous-marin");
            sm.destruction();
            qg.NotifyObservers();
        }
    }
}
