package fred;

import java.util.ArrayList;

interface IObservable {
  public void register(IObserver o);
  public void unRegister(IObserver o);
  public void notifyObservers();
}

interface IObserver {
  public void update(Menace m);
}

class Menace {
  public Menace(String id, int x, int y) {
    this.id = id;
    this.x = x;
    this.y = y;
  }
  public String id;
  public int x;
  public int y;
}

class QuartierGeneral implements IObservable {
  private ArrayList<IObserver> observers = new ArrayList<IObserver>();
  public void register(IObserver obs) {
    observers.add(obs);
  }
  public void unRegister(IObserver obs) {
    int i = observers.indexOf(obs);
    if(i>=0)
      observers.remove(i);
  }
  public void notifyObservers() {
    Menace m = new Menace("Artillerie", 10, 10);
    for(IObserver obs : observers)
      obs.update(m);
  }
}

class Soldat implements IObserver {
  private QuartierGeneral qg;
  public Soldat(QuartierGeneral qg) {
    this.qg = qg;
    qg.register(this);
  }
  public void update(Menace m) {
   System.out.println("Soldat:");
   System.out.println(m.id + " en vue");
   System.out.println("Je me cache\n");
  }
}

class SousMarin implements IObserver {
  private QuartierGeneral qg;
  public SousMarin(QuartierGeneral qg) {
    this.qg = qg;
    qg.register(this);
  }
  public void update(Menace m) {
    System.out.println("Sous-Marin:");
    System.out.println(m.id + " en vue");
    System.out.println("Je plonge\n");
  }
  public void destruction() {
    System.out.println("Sous-Marin detruit\n");
    qg.unRegister(this);
  }
}

class Avion implements IObserver {
  private QuartierGeneral qg;
  public Avion(QuartierGeneral qg) {
    this.qg = qg;
    qg.register(this);
  }

  public void update(Menace m) {
    System.out.println("Avion:");
    System.out.println(m.id + " en vue");
    System.out.println("J'attaque\n");
  }
}

public class Jeu {
  public static void main(String[] args) {
    QuartierGeneral qg = new QuartierGeneral();
    Soldat s = new Soldat(qg);
    SousMarin sm = new SousMarin(qg);
    Avion a = new Avion(qg);

    qg.notifyObservers();
    System.out.println("Simulation destruction du sous-marin");
    sm.destruction();
    qg.notifyObservers();
  }
}
