﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Runtime.Serialization.Json;
using System.Text;
using System.Threading.Tasks;
using Windows.Networking.Connectivity;
using Windows.Storage;

namespace StoreAppGotoTags
{
    public class Message
    {
        public String Sender { get; set; }
	    public String Content {get; set;}
    }

    //public class Message
    //{
    //    [SQLite.PrimaryKey]
    //    [SQLite.AutoIncrement]
    //    public int Id { get; set; }
    //    public String Sender { get; set; }
    //    public String Content { get; set; }
    //}

    public class Article
    {
        public void CheckNetworkStaus()
        {
            ConnectionProfile profile = NetworkInformation.GetInternetConnectionProfile();
            if (profile.GetNetworkConnectivityLevel() == NetworkConnectivityLevel.InternetAccess) {
                Debug.WriteLine("connected to internet");
            }
            {
                Debug.WriteLine("Not connected to internet");
            }
        }

        public void ListenToNetworkChanges()
        {
            NetworkInformation.NetworkStatusChanged += NetworkInformation_NetworkStatusChanged;
        }

        void NetworkInformation_NetworkStatusChanged(object sender)
        {
            CheckNetworkStaus();
        }

        public void ConsumService()
        {
            Service1Client client = new Service1Client();
            Double result = await client.SumAsync(5, 6);
        }

        public async void PostData()
        {
            HttpClient client = new HttpClient();
            HttpContent content = new System.Net.Http.StringContent("hello world !!");
            HttpResponseMessage responce = await client.PostAsync("http://localhost/message", content);

            if (responce.IsSuccessStatusCode) {
                String msg = await responce.Content.ReadAsStringAsync();
                Debug.WriteLine("Message sent!");
            } else {
                Debug.WriteLine(String.Format("Sending message failed with status code {0}", responce.StatusCode));
            }
        }

        public async void GetData()
        {
            HttpClient client = new HttpClient();
            HttpResponseMessage response = await client.GetAsync("http://localhost/message");

            if (response.IsSuccessStatusCode) {
                String msg = await response.Content.ReadAsStringAsync();
                Debug.WriteLine(String.Format(msg));
            } else {
                Debug.WriteLine(String.Format("Request failed with status code {0}", response.StatusCode));
            }
        }

        public void SaveMessage1()
        {
            var localSettings = ApplicationData.Current.LocalSettings;

            // Create a setting
            localSettings.Values["message"] = "Hello Windows";

            // Read data from a setting
            Object value = localSettings.Values["message"];

            if (value != null) {
                // No data
            } else {
                // Access data in value
            }
            // Delete a setting
            localSettings.Values.Remove("message");
        }

        public async Task SaveAsync<T>(T Obj, string FileName)
        {
            try {
                if (Obj != null) //dont save a null objet
            {
                    //Create a file in the application folder
                    StorageFile file = null;
                    StorageFolder folder = ApplicationData.Current.LocalFolder;
                    file = await folder.CreateFileAsync(FileName, CreationCollisionOption.ReplaceExisting);

                    //Serialize the data into the file using JSON format
                    var writeStream = await file.OpenAsync(FileAccessMode.ReadWrite);
                    DataContractJsonSerializer serializer = new DataContractJsonSerializer(typeof(T));
                    Stream outStream = writeStream.AsStreamForWrite();
                    serializer.WriteObject(outStream, Obj);
                }
            } catch (Exception e) {
                //something wrong appended
                System.Diagnostics.Debug.WriteLine(e.ToString());
            }
        }

        public async Task<T> LoadAsync<T>(string FileName)
        {
            try {
                //Open the file
                StorageFile file = null;
                StorageFolder folder = ApplicationData.Current.LocalFolder;
                file = await folder.GetFileAsync(FileName);
                var readStream = await file.OpenAsync(FileAccessMode.Read);

                //Read the object
                Stream inStream = readStream.AsStreamForRead();
                DataContractJsonSerializer serializer = new DataContractJsonSerializer(typeof(T));
                T obj = (T)serializer.ReadObject(inStream);

                return obj;
            } catch (FileNotFoundException) {
                //No persistance file found
                return default(T);
            } catch (Exception) {
                //something wrong appended
                return default(T);
            }
        }
        
        public async void SaveMessage2()
        {
            var messages = new List<Message>();
            messages.add(new Message(){ Sender = "admin", Content ="It works !!"});
	
	        //Save the list of messages
            await SaveAsync(messages, "messages.json");

	        //read the list of messages
	        var readMessages = LoadAsync<List<Messages>>("messages.json");
        }

        public void InitDB()
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "db.sqlite");
            using (var db = new SQLite.SQLiteConnection(dbPath)) {
                // Create the table if they don't exist
                db.CreateTable<Message>();
            }
        }

        public void InsertInDB()
        {
            using (var db = new SQLite.SQLiteConnection(dbPath)) {
                db.Insert(new Message() { Sender = "Admin", Content = "It works!" });
            }
        }

        public void ReadFromDB()
        {
            using (var db = new SQLite.SQLiteConnection(dbPath)) {
                // Create the table if they don't exist
                var messages = db.Table<Message>().ToList();
            }
        }
    }
}
