from machine import Pin
from machine import ADC
from time import sleep

ledblue  = Pin(16, Pin.OUT)  #bleu
ledgreen = Pin(5, Pin.OUT)   #vert
ledred   = Pin(4, Pin.OUT)   #rouge

adc = ADC(0)  #LM35 sur l'analogique 0

ledgreen.value(0)
ledblue.value(0)
ledblue.value(1)
sleep(.3)
ledblue.value(0)
ledgreen.value(1)
sleep(.3)
ledgreen.value(0)
ledred.value(1)
sleep(.3)
ledred.value(0)
sleep(1)

while True:
  reading = adc.read()
  celsius_temp = round(reading/3.95, 1)
  print(celsius_temp)
  
  ledgreen.value(0)
  ledblue.value(0)
  ledred.value(0)
  
  if (celsius_temp) > 24.0:
    ledred.value(1)
  else:
    if (celsius_temp) < 22.0:
      ledblue.value(1)
    else:
      ledgreen.value(1)
  
  sleep(2.0)