from machine import Pin
from machine import ADC
from time import sleep

import socket

#import machine
html = """<!DOCTYPE html>
<html>
    <head><title>Temperature</title></head>
    <body>
      %s
    </body>
</html>
"""

celsius_temp = 10.0

ledblue  = Pin(16, Pin.OUT)  #bleu
ledgreen = Pin(5, Pin.OUT)   #vert
ledred   = Pin(4, Pin.OUT)   #rouge

adc = ADC(0)  #LM35 sur l'analogique 0

ledgreen.value(0)
ledblue.value(0)
ledblue.value(1)
sleep(.3)
ledblue.value(0)
ledgreen.value(1)
sleep(.3)
ledgreen.value(0)
ledred.value(1)
sleep(.3)
ledred.value(0)
sleep(1)

addr = socket.getaddrinfo('0.0.0.0', 80)[0][-1]
s = socket.socket()
s.bind(addr)
s.listen(1)

while True:
  #print('Boucle ')   
  s.settimeout(2)
  try:    
    conn, addr = s.accept()
  except OSError as er:
    pass
    #print(er.args[0] in (110, 'timed out'))
    # 110 is ETIMEDOUT
  else:
    #print('Client connecté de ', addr)
    conn_file = conn.makefile('rwb', 0)
    while True:
        line = conn_file.readline()
        #print('Line ', line)
        if not line or line == b'\r\n':
            break
    
    response = html % celsius_temp + '\n'
    #print('Client receives ', response)
    conn.send('HTTP/1.1 200 OK\n')
    conn.send('Content-Type: text/html\n')
    conn.send('Connection: close\n\n')
    conn.sendall(response)
    conn.close()
    
  reading = adc.read()
  celsius_temp = round(reading/3.95, 1)
  #print(celsius_temp)
  
  ledgreen.value(0)
  ledblue.value(0)
  ledred.value(0)
  
  if (celsius_temp) > 24.0:
    ledred.value(1)
  else:
    if (celsius_temp) < 22.0:
      ledblue.value(1)
    else:
      ledgreen.value(1)
    