use std::env;

struct Division {
    numerateur: i32,
    denominateur: i32,
}

impl Division {
    fn new(x: i32, y: i32) -> Division {
        Division {
            numerateur: x,
            denominateur: y,
        }
    }

    fn calculer(&self) -> i32 {
        match self.denominateur {
            0 => panic!("Division par 0"),
            1 => self.numerateur,
            _ => self.numerateur / self.denominateur
        }
    }
}

trait HasSymbol {
    fn symbol(&self) -> String;
}

impl HasSymbol for Division {
    fn symbol(&self) -> String {
        "/".to_string()
    }
}

fn main() {
    let numerateur = match env::args().nth(1) {
        Some(argument) => argument,
        None => panic!("Argument obligatoire manquant : le numérateur")
    };

    let numerateur = match numerateur.parse::<i32>() {
        Ok(numerateur) => numerateur,
        Err(error) => panic!("Impossible de convertir notre argument. Raison: {}", error)
    };

    let division = Division::new(numerateur, 2);
    display_symbol(division);

    let resultat = division.calculer();
    println!("Résultat : {}", resultat);
}

fn display_symbol(division: Division) {
    println!("Symbole: {}", division.symbol());
}
