package com.ssaurel.inappbilling;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.ssaurel.inappbilling.util.IabHelper;
import com.ssaurel.inappbilling.util.IabResult;
import com.ssaurel.inappbilling.util.Inventory;
import com.ssaurel.inappbilling.util.Purchase;

public class MainActivity extends Activity {

	private Button buyBtn;
	private Button clickBtn;
	private TextView buyTxt;
	private IabHelper iabHelper;
	public static final String PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAv0Ww37il1B5qEYy0bXMrpmbRXMIHVJQlUut8/xzaHfvLPSXGvnDdpK7UO3iO3JtnbIChbmR8rdEOj12bWG10roZyapAwxGn9eBUiDJQwbDnLqlCNzAIHHGgjzYQUfCXQbHhZxDrzJzbFUf0tV61RcO2DHud4k+NYd38rM/+rgLqj60ANLwvNB+lYRINTQlH9YGh/1o6s/qNvxRPYlpb2bSOGhOKfLw+v2zAsufCMoFh92urn9n9zjQ2NWwM+F+wgFPt7UkvQ8b30soz5bK8MQVikXKJyWzTyeJ43GeX5aoLrJi0IolkZcEB2mqvHy6elR+J/Vt+tRzyL+A2onqFv2wIDAQAB";
	public static final String TAG = "MainActivity";
	//public static final String ITEM_SKU = "android.test.purchased";
	public static final String ITEM_SKU = "com.ssaurel.items.btnclick";
	public static final int REQUEST_CODE = 10001;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		buyBtn = (Button) findViewById(R.id.buyBtn);
		clickBtn = (Button) findViewById(R.id.clickBtn);
		clickBtn.setEnabled(false);
		buyTxt = (TextView) findViewById(R.id.buyTxt);
		buyTxt.setVisibility(View.VISIBLE);

		// connexion
		iabHelper = new IabHelper(this, PUBLIC_KEY);

		iabHelper.startSetup(new IabHelper.OnIabSetupFinishedListener() {

			@Override
			public void onIabSetupFinished(IabResult result) {
				if (!result.isSuccess()) {
					Log.i(TAG, "In-app Billing setup failed : " + result);
				} else {
					Log.i(TAG, "In-app Billing setup OK");
				}
			}
		});
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		
		if (iabHelper != null)
			iabHelper.dispose();
		
		iabHelper = null;
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (!iabHelper.handleActivityResult(requestCode, resultCode, data)) {
			super.onActivityResult(requestCode, resultCode, data);
		}
	}

	public void buttonClick(View v) {
		clickBtn.setEnabled(false);
		buyTxt.setVisibility(View.VISIBLE);
		buyBtn.setEnabled(true);
	}

	public void buyClick(View v) {
		iabHelper.launchPurchaseFlow(this, ITEM_SKU, REQUEST_CODE, mPurchaseFinishedListener, "");
	}

	public void consumeItem() {
		iabHelper.queryInventoryAsync(mReceivedInventoryListener);
	}

	IabHelper.QueryInventoryFinishedListener mReceivedInventoryListener = new IabHelper.QueryInventoryFinishedListener() {
		public void onQueryInventoryFinished(IabResult result, Inventory inventory) {

			if (result.isFailure()) {
				// Gestion erreur
			} else {
				iabHelper.consumeAsync(inventory.getPurchase(ITEM_SKU), mConsumeFinishedListener);
			}
		}
	};

	IabHelper.OnConsumeFinishedListener mConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener() {
		public void onConsumeFinished(Purchase purchase, IabResult result) {

			if (result.isSuccess()) {
				clickBtn.setEnabled(true);
			} else {
				// Gestion erreur
			}
		}
	};

	IabHelper.OnIabPurchaseFinishedListener mPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener() {
		public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
			if (result.isFailure()) {
				// Grer l'erreur
				return;
			} else if (purchase.getSku().equals(ITEM_SKU)) {
				consumeItem();
				buyBtn.setEnabled(false);
				buyTxt.setVisibility(View.GONE);
			}

		}
	};

}
