﻿//# debug

/** Permet de faire de l'autocompletion **/
/*
/*  Arguments  */
/* ----------- */
/* elmtID   : ID de la textBox sur lequel on appliquera l'autocompletion
/* url      : adresse de la page de réponse 
/* delay    : intervalle minimum entre 2 requetes Ajax
/* minChars : nombre minimum de caractère dans la textbox pour faire une requete ajax
/* 
**/
var AjaxTextbox = function(elmtID, url, delay, minChars)
{
    // créer et retourne un nouvelle objet XMLHttpRequest
    var createXHRObject = function()
    {
        var tempXHR = null;
        
        // Instantiation de notre objet XMLHttpRequest
        if(window.XMLHttpRequest) 
           tempXHR = new XMLHttpRequest();                      // Firefox
        else if(window.ActiveXObject) 
           tempXHR = new ActiveXObject("Microsoft.XMLHTTP");    // Internet Explorer
        else   
           return null;                                         // XMLHttpRequest non supporté par le navigateur
           
        return tempXHR;
    }
    
    // créer un nouveau noeud div et le positionne juste en dessous de la textbox
    var writeDivResult = function()
    {
        var tempDiv = document.createElement('div');
        tempDiv.className = 'AjaxTextBoxResult';
        tempDiv.style.position = 'absolute'; 
        
        // Permet de recuperer les valeurs précises de offsetLeft et offsetTop, dans certains cas la valeur retourné ne serait pas correcte pour IE 
        // >> http://www.asp-php.net/scripts/scripting/jsieselect.php?page=3 merci Aurél ;)
        var oObj = elmt;
                
        var offsetLeft = 0; 
        while (oObj && oObj.tagName != 'BODY') 
        { 
            eval('offsetLeft += oObj.offsetLeft;');
            oObj = oObj.offsetParent; 
        }
        
        oObj = elmt;
        var offsetTop = 0; 
        while (oObj && oObj.tagName != 'BODY') 
        { 
            eval('offsetTop += oObj.offsetTop;');
            oObj = oObj.offsetParent; 
        }
         
        tempDiv.style.top = ( elmt.offsetHeight + offsetTop ) + 'px';
        tempDiv.style.left =  offsetLeft + 'px';
        tempDiv.style.width = elmt.offsetWidth + 'px';
        tempDiv.style.display = 'none';
        
        document.getElementsByTagName('body')[0].appendChild(tempDiv);
        
        return tempDiv;
    }
    

    // permet de faire une requete
    var makeRequest = function(request)
    {
        lastRequest = request;                          // On stock la valeur 
        
        if (request.length < minChars)                  // On quitte la fonction si on a pas assez de lettre
        {
            hideResult();                               // On cache ce qu'il y avait comme requete
            return; 
        }
        
        canMakeRequest = false;                         // On vient de faire une requete donc on interdit d'en refaire une tout de suite
        window.setTimeout(                              // On execute une fonction dans delay seconde
            function()
            {
                canMakeRequest = true;                  // on ré-authorise à faire la requete
                if (elmt.value != lastRequest)          // on vérifie qu'il n'y a pas une valeur
                    makeRequest(elmt.value);
            } , delay * 1000);


        // initialise une nouvelle requete, avec la méthode post, sur l'url spécifié en mode asynchrone
        xhr_object.open('post', url, true);

        // lorsque la requete change d'etat
        // on vérifie qu'elle est finit (readyStat ==4)
        // si oui on indique que la requete est finit et on
        // appelle la fonction qui va afficher les resultats
        xhr_object.onreadystatechange = function() 
        {
           if(xhr_object.readyState == 4) 
           {
                isRequestActive = false;
                showResult();
           }
        }
        
        // Sert pour l'encodage des paramètres de la requete
        xhr_object.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        // Créer la requete en passant le paramètre encodé
        xhr_object.send('Query=' + escape(request));
        // on indique qu'il y a une requete d'active 
        isRequestActive = true;

    }
    
    // Cette fonction est appellé une fois la requete terminé
    // elle permet d'afficher le div de suggestion
    var showResult = function()
    {
    
        // On vérifie qu'il y ait des resultats et qu'il n'y ait pas d'erreur
        if ( (xhr_object.responseText == '') || (xhr_object.status  != 200) )
        {
            hideResult();
            return;
        }
    
        divResult.style.display = 'block';
        divResult.innerHTML = xhr_object.responseText;

        // on vide la collection d'items
        items = new Array();
            
        // on recupere tous les noeud de la réponse et on garde seulement les noeuds tags
        var fullItems = divResult.getElementsByTagName('ul')[0].childNodes; 
        for (var i = 0; i < fullItems.length; i++)
        {
            if (fullItems[i].nodeType == 1)
                items.push(fullItems[i]);
        }
                
        for (var i = 0; i < items.length; i++)
        {
            // au passage de la souris, on change le className
            items[i].onmouseover = function()
            {
                for(var j = 0; j < items.length; j++)
                    items[j].className = ''; 
                this.className = 'Hover';
            }
            // lorsque la souris quitte, on enleve le className
            items[i].onmouseout = function()
            {
                for(var j = 0; j < items.length; j++)
                    items[j].className = ''; 
            }
            // quand on clique dessus, on met le contenu du li dans le textbox
            items[i].onmousedown= function()
            {
                elmt.value = this.innerHTML;
            }
        }
        
        // On affiche l'item 0 par défaut
        highlihgtItem(0);
        
    }
    
    // Permet de cacher le div de suggestion
    var hideResult = function()
    {
        divResult.style.display = 'none';
    }
    
    // Contient une liste des différent items (li)
    var items = new Array(); 
    
    // Variable contenant l'item actif 
    var currentItemIndex = 0; 
    
    // Permet de mettre l'item actif dans la textbox 
    var validItem = function()
    {
        elmt.value = items[currentItemIndex].innerHTML;
        lastRequest = elmt.value;
    }
    
    // Permet d'afficher le n-ieme item de la liste 
    var highlihgtItem = function(index)
    {
        if (index < 0)
            index += items.length;
        index = index % items.length;
        for(var i = 0; i < items.length; i++)
        {
            if(i==index)
                items[i].className = 'Hover';
            else
                items[i].className = '';
        }
        currentItemIndex = index;
    }

    // On recupere la textbox et on vérifie que tout est correct
    var elmt = document.getElementById(elmtID);             
    if (elmt && elmt.tagName.toLower != 'input' && elmt.type != 'text')
        throw new Error('The HTML tag is not correct for an AjaxTextBox');

    if ( !delay || delay < 0 || delay > 2)
        delay = .5
    if ( !minChars || minChars < 0)
        minChars = 2;

    elmt.autocomplete = "off";                              // désactive l'autocomplétion de certains navigateurs
    
    var xhr_object = createXHRObject();                     // déclaration de l'objet xmlHttpRequest
    if (!xhr_object)                                        // si le navigateur ne peut pas faire de l'ajax inutile d'aller plus loin
        return; 
        
    var isRequestActive = false;                            // simple boolean pour savoir s'il y a une requete en cours
    var canMakeRequest = true;                              // simple boolean pour savoir si on peut faire une requete
    var lastRequest = null;                                 // permet de garder la valeur de la derniere requete afin de ne pas la reexecuter
    
    var divResult = writeDivResult();                       // déclaration du div qui contiendra le résultat
    
    elmt.onkeydown = function(e)                            // abonnement sur l'evenement "appuie sur la touche"
    {
        e = e || window.event;

        switch (e.keyCode) 
        {
            case 13:            // Enter
                validItem(); 
                hideResult();
                return false;
            
            case 38:            // Top
                highlihgtItem(currentItemIndex - 1)
                break; 
            
            case 40:            // Bottom
                highlihgtItem(currentItemIndex + 1)
                break;
            
            case 27:            // Escape 
                hideResult(); 
                break;
            
            default: 
                break; 
        }
        
    }
    
    elmt.onkeyup = function()                               // abonnement sur l'evenement "relachement de la touche"
    {
        if (isRequestActive)                                // S'il y a une requete en attente on l'annule
            xhr_object.abort();

        if (canMakeRequest && elmt.value != lastRequest)    // Si on peut faire une requete on la fait tout de suite
            makeRequest(elmt.value);                        // On fait notre requete en passant en paramètre le contenu de la textbox
    }

    elmt.onblur = function()                                // abonnement sur l'evenement "perte du focus de la textbox"
    {
        hideResult();                                       // On cache les resultats
    }
}

