package monrcp;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MyAction extends Action {
	private final IWorkbenchWindow window;
	
	public MyAction(IWorkbenchWindow window, String label) {
		this.window = window;
        setText(label);
        // Les deux dfinitions sont ncessaires
        // pour la barre d'outils
		setId(ICommandIds.CMD_HINT);
        setActionDefinitionId(ICommandIds.CMD_HINT);
		setImageDescriptor(getImageDescriptor("/icons/progicon.png"));
	}
	
	public void run() {
		if(window != null) {	
			
			MyView myView;
			myView = (MyView)window.getActivePage().findView(MyView.ID);
			myView.abonnementProgrammez();
		}
	}
	
	public static ImageDescriptor getImageDescriptor(String path) {
		ImageDescriptor  id = AbstractUIPlugin.imageDescriptorFromPlugin("monrcp", path);
		return id;
	}
}
