/*
 * SystemTrayDemo.java
 *
 * Created on 19 janvier 2006, 12:40
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.programmez.mustangdemo;

/**
 *
 * @author Fred
 */

import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Toolkit;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import static java.awt.TrayIcon.MessageType.*;

public class SystemTrayDemo {
    
    private
            TrayIcon trayIcon;
    public SystemTrayDemo() {
        if (!SystemTray.isSupported()) {
            System.out.println("Votre systme ne supporte pas le SystemTray");
            System.exit(0);
        }
        SystemTray tray = SystemTray.getSystemTray();
        Image image = Toolkit.getDefaultToolkit().getImage("c:/progicon.gif");
        MouseListener mouseListener =
                new MouseListener() {
            public void mouseClicked(MouseEvent e) {
                System.out.println("Evenement Mouse Clicked");
            }
            public void mouseEntered(MouseEvent e) {
                System.out.println("Evenement Mouse entered!");
            }
            public void mouseExited(MouseEvent e) {
                System.out.println("Evenement Mouse exited!");
            }
            public void mousePressed(MouseEvent e) {
                System.out.println("Evenement Mouse pressed!");
            }
            public void mouseReleased(MouseEvent e) {
                System.out.println("Evenement Mouse released!");
            }
        };
        
        ActionListener exitListener =
                new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                trayIcon.displayMessage("Programmez!", "A bientt...", INFO);
                try {
                    Thread.sleep(2000);
                } catch(Exception ex) {
                    ex.printStackTrace();
                } finally {
                    System.exit(0);
                }
            }
        };
        
        PopupMenu popup = new PopupMenu();
        MenuItem defaultItem = new MenuItem("Programmez!");
        defaultItem.addActionListener(exitListener);
        popup.add(defaultItem);
        trayIcon = new TrayIcon(image, "Tray Demo", popup);
        ActionListener actionListener =
                new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("Action: double clic sur l'icne");
            }
        };
        
        trayIcon.setImageAutoSize(true);
        trayIcon.addActionListener(actionListener);
        trayIcon.addMouseListener(mouseListener);
        trayIcon.setToolTip("Abonnez vous :-)");
        try {
            tray.add(trayIcon);
        } catch (AWTException e) {
            System.err.println("L'icne n'a pas public tre insre ");
        }
    }

    public static void main(String[] args) {
    SystemTrayDemo std = new SystemTrayDemo();
    }
}
