class ItemsController < ApplicationController
  before_filter :find_list
  
  def index
    @items = Item.find :all, :order => "text ASC"
  end
  
  def new
    @item = Item.new
  end
  
  def create
    @item = Item.new params[:item]
    @item.list = @list
    if @item.save
      flash[:notice] = "L'élément a été créée avec succès"
      
      redirect_to items_path(@list)
    else
      render :action => "new"
    end
  end
  
  def show
    @item = Item.find params[:id]
  end
  
  def edit
    @item = Item.find params[:id]
  end
  
  def update
    @item = Item.find params[:id]
    
    if @item.update_attributes params[:item]
      flash[:notice] = "L'élément a été modifiée avec succès"
      
      redirect_to items_path(@list)
    else
      render :action => "edit"
    end
  end
  
  def done
    @item = Item.find params[:id]
    @item.done = true
    @item.save
    
    redirect_to items_path(@list)
  end
  
  def redo
    @item = Item.find params[:id]
    @item.done = false
    @item.save
    
    redirect_to items_path(@list)
  end
  
  def destroy
    @item = Item.find params[:id]
    @item.destroy
    
    redirect_to items_path
  end
  
  private
  
  def find_list
    @list_id = params[:list_id]
    redirect_to lists_path unless @list_id
    @list = List.find @list_id
  end
end
