class ListsController < ApplicationController
  
  def index
    @lists = List.find :all, :order => "name ASC"
  end
  
  def new
    @list = List.new
  end
  
  def create
    @list = List.new params[:list]
    if @list.save
      flash[:notice] = "La liste a été créée avec succès"
      
      redirect_to lists_path
    else
      render :action => "new"
    end
  end
  
  def edit
    @list = List.find params[:id]
  end
  
  def update
    @list = List.find params[:id]
    
    if @list.update_attributes params[:list]
      flash[:notice] = "La liste a été modifiée avec succès"
      
      redirect_to lists_path
    else
      render :action => "edit"
    end
  end
  
  def destroy
    @list = List.find params[:id]
    @list.destroy
    
    redirect_to lists_path
  end
  
  def last
  end
  
  def publish
  end
end
