using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Feeds.Interop;
using System.Reflection;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            FeedsManager mgr = new FeedsManagerClass();
            IFeed feed = (IFeed)mgr.GetFeedByUrl("http://www.programmez.com/rss/rss_actu.php");
        
            foreach (PropertyInfo info in typeof(IFeed).GetProperties())
                Console.WriteLine("{0} = {1}", info.Name, info.GetValue(feed, null));
            Console.WriteLine();

            Console.WriteLine("Items:");
            foreach (IFeedItem item in (IFeedsEnum)feed.Items)
            {
                foreach (PropertyInfo Info in typeof(IFeedItem).GetProperties())
                    if (Info.Name == "Title") {
                        Console.WriteLine("{0}",Info.GetValue(item, null));
                    }
                Console.WriteLine();
            }
            Console.ReadLine();
        }
    }
}