using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Feeds.Interop;
using System.Threading;

namespace RSS3
{
    class Program
    {
        static void Main(string[] args)
        {
            FeedsManager mgr = new FeedsManagerClass();
            IFeed feed = (IFeed)mgr.GetFeedByUrl("http://www.programmez.com/rss/rss_actu.php");

            IFeedEvents_Event watcher = (IFeedEvents_Event)feed.GetWatcher(FEEDS_EVENTS_SCOPE.FES_ALL, FEEDS_EVENTS_MASK.FEM_FEEDEVENTS);
            watcher.FeedDownloading += new IFeedEvents_FeedDownloadingEventHandler(watcher_FeedDownloading);
            watcher.FeedDownloadCompleted += new IFeedEvents_FeedDownloadCompletedEventHandler(watcher_FeedDownloadCompleted);
            watcher.FeedItemCountChanged += new IFeedEvents_FeedItemCountChangedEventHandler(watcher_FeedItemCountChanged);

            Console.WriteLine("Tlchargement depuis " + feed.Name);
            feed.AsyncDownload();

            new AutoResetEvent(false).WaitOne();
}
            static void watcher_FeedItemCountChanged(string Path, int itemCountType)
            {
               Console.WriteLine("Compteur modifi - Chemin={0}, Count={1}", Path, itemCountType);
            }

            static void watcher_FeedDownloadCompleted(string Path, FEEDS_DOWNLOAD_ERROR Error)
            {
               Console.WriteLine("Fil tlcharg  100% - Chemin={0}, Error={1}", Path, Enum.GetName(typeof(FEEDS_DOWNLOAD_ERROR), Error));
            }

            static void watcher_FeedDownloading(string Path)
            {
               Console.WriteLine("Fil en tlchargement - Chemin={0}", Path);
            }
        }
    }