using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Feeds.Interop;
using System.Runtime.InteropServices;

namespace RSS4
{
    class Program
    {
        static void Main(string[] args)
        {
            IFeedsManager feedmgr = null;
            IFeedFolder rootfolder = null;
            IFeedFolder folder = null;
            IFeed feed = null;

            try
            {
                // instanciation d'un nouveau gstionnaire de feeds
                feedmgr = new FeedsManagerClass();

                // recherche de la rfrence  la racine
                rootfolder = (IFeedFolder)feedmgr.RootFolder;

                // recherche du handle du sous-rpertoire ddi aux feeds de Programmez
                folder = (IFeedFolder)rootfolder.GetSubfolder("Programmez");

                feed = (IFeed)folder.CreateFeed("Les 10 derniers blogs", "http://www.programmez.com/rss/rss_blogs.php");
                // now force an async download of the items in the feed
                feed.AsyncDownload();
            }
            finally
            {
                Marshal.ReleaseComObject(feed);
                Marshal.ReleaseComObject(folder);
                Marshal.ReleaseComObject(rootfolder);
                Marshal.ReleaseComObject(feedmgr);
            }
        }
    }
}
