package net.zekey;

import java.sql.Connection;
import java.sql.Statement;

import javax.sql.DataSource;

import net.zekey.business.exceptions.ArticleNotFoundException;
import net.zekey.business.exceptions.BusinessException;
import net.zekey.interfaces.business.IStockService;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 *
 * <b>Copyright (c) 2006 [ipt] Innovation Process Technology AG</b><br/>
 * Baarerstrasse 14, CH-6400 Zug, Switzerland, info@ipt.ch<br/>
 * all rights reserved
 * <p/>
 *
 * Classe de test destine  dmontrer l'usage de Spring et des transactions
 * 
 * @author steve.hostettler
 *
 */
public class SpringTrx {

	public static void main(String[] args) {
        //Initialize le context de spring avec notre fichier de configuration.
		ApplicationContext context = 
            new ClassPathXmlApplicationContext("applicationContext.xml");
		
        Logger.getLogger(SpringTrx.class).info("-----------------------------");
        
        /* Cre une nouvelle base de donnes.
         * Attention : si la base de donnes existe dja : rpertoire derbyDB
         * dans le rpertoire racine de l'application, le bloc suivant renverra
         * une exception. Entre chaque usage du programme supprim le rpertoire
         * derbyDB.
         */
        try{
            Logger.getLogger(SpringTrx.class).info("Cration de la " +
                    "base de donne de test");
            
            //Connection  la base de donnes
            DataSource datasource = (DataSource) 
                    context.getBean("prodDataSource");
            Connection conn=datasource.getConnection();
            Statement s = conn.createStatement();
            
            //Cration du shma de test
            s.execute("CREATE TABLE articles(  " +
                    "article_id VARCHAR(24) NOT NULL, " +
                    "qty INT NOT NULL,  " +
                    "CONSTRAINT articles_pk PRIMARY KEY (article_id))");
                     
            s.execute("INSERT INTO articles (article_id, qty) " +
                    "VALUES( 'articleId001', 12 )");
            s.execute("INSERT INTO articles (article_id, qty) " +
                    "VALUES( 'articleId002', 0 )");
            s.execute("INSERT INTO articles (article_id, qty) " +
                    "VALUES( 'articleId003', 3 )");
            
        }catch(Exception e){
            Logger.getLogger(SpringTrx.class).error("Erreur pendant la " +
                    "cration de la base de donnes: " + e.getMessage());
        }
        
        Logger.getLogger(SpringTrx.class).info("-------------------------");
        Logger.getLogger(SpringTrx.class).info("Demande une instance du service" +
                " de gestion des stocks  Spring.");
        //Demande l'instance du service de gestion de stock  spring
        IStockService service = (IStockService) context.getBean("stockService");
        Logger.getLogger(SpringTrx.class).info("-------------------------");
		try {
            Logger.getLogger(SpringTrx.class).info("-------------------------");
            Logger.getLogger(SpringTrx.class).info("Dbut de transaction");
            Logger.getLogger(SpringTrx.class).info("Qty d'article en stock" +
                    " de type articleId001: " 
                    + service.getQtyEnStock("articleId001"));
            Logger.getLogger(SpringTrx.class).info("Sort 2 articles du stock");                 
            Logger.getLogger(SpringTrx.class).info("-------------------------");
            
            /*
             * Sort deux articles du stock. A ce stade il devrait rester 12 
             * articles en stock.
            */
            Logger.getLogger(SpringTrx.class).info("-------------------------");
			service.sortArticleDuStock("articleId001", 2);
            Logger.getLogger(SpringTrx.class).info("Fin de transaction");
            Logger.getLogger(SpringTrx.class).info("-------------------------");
		} catch (BusinessException qe) {
            Logger.getLogger(SpringTrx.class).error(qe.getClass());
		}
        
        try {
            Logger.getLogger(SpringTrx.class).info("-------------------------");
            Logger.getLogger(SpringTrx.class).info("Dbut de transaction");
            Logger.getLogger(SpringTrx.class).info("Qty d'article en stock" +
                    " de type articleId001: " 
                    + service.getQtyEnStock("articleId001"));
            
            Logger.getLogger(SpringTrx.class).info("Sort -1 articles du stock");
            /*
             * Sort une quantit ngative du stock, cela doit provoquer 
             * une exception et donc un rollback.
             */            
            service.sortArticleDuStock("articleId001", -1);
            Logger.getLogger(SpringTrx.class).info("Fin de transaction");
            Logger.getLogger(SpringTrx.class).info("-------------------------");
        } catch (BusinessException qe) {
            Logger.getLogger(SpringTrx.class).error(qe.getClass());
        }        
        
        try {
            Logger.getLogger(SpringTrx.class).info("-------------------------");
            Logger.getLogger(SpringTrx.class).info("Dbut de transaction");
            Logger.getLogger(SpringTrx.class).info("Qty d'article en stock" +
                    " de type articleId001: " 
                    + service.getQtyEnStock("articleId001"));
            Logger.getLogger(SpringTrx.class).info("Sort 11 articles du stock");
            
            /*
             * Sort plus d'articles (11) qu'il n'y en a rellement (10),
             * provoque une exception et donc un rollback.
             */
            service.sortArticleDuStock("articleId001", 11);
            Logger.getLogger(SpringTrx.class).info("Fin de transaction");
            Logger.getLogger(SpringTrx.class).info("-------------------------");
        } catch (BusinessException qe) {
            Logger.getLogger(SpringTrx.class).error(qe.getClass());
        }        

        try {
            Logger.getLogger(SpringTrx.class).info("-------------------------");
            Logger.getLogger(SpringTrx.class).info("Qty d'article en stock" +
                " de type articleId001: " 
                    + service.getQtyEnStock("articleId001"));
        } catch (ArticleNotFoundException ne) {
            Logger.getLogger(SpringTrx.class).error(ne.getClass());
        }
        
	}	
}
