package net.zekey.business;

import net.zekey.business.exceptions.ArticleNotFoundException;
import net.zekey.business.exceptions.NotEnoughArticleInStockException;
import net.zekey.business.exceptions.QtyNegativeException;
import net.zekey.interfaces.business.IStockService;
import net.zekey.interfaces.dao.IStockDAO;

import org.apache.log4j.Logger;

/**
 * Implmente le service de manipulation du stock.
 * 
 * @author steve.hostettler
 *
 */
public class StockService implements IStockService {

	/**
	 * L'instance du dao sera inject par Spring
	 * lors de l'initialisation du service.
	 */
	IStockDAO mStockDao = null;
	
	/* (non-Javadoc)
	 * @see net.zekey.interfaces.business.IStockService#sortArticleDuStock(java.lang.String, int)
	 */
	public void sortArticleDuStock(String pArticleId, int pQty)
		throws ArticleNotFoundException, 
        QtyNegativeException, 
        NotEnoughArticleInStockException {				
		
		// Si la quantit est ngative le service choue.
		if(pQty<0){
			throw new QtyNegativeException();
		}

        //Test si l'article existe dans la base de donnes
		if(!mStockDao.articleExist(pArticleId)){
			throw new ArticleNotFoundException();
		}

        Logger.getLogger(this.getClass()).info("Nombre d'article [" 
                + pArticleId + "] : " + mStockDao.getQtyEnStock(pArticleId));
        //Sort la quantit du stock.
		mStockDao.sortArticleDuStock( pArticleId, pQty);

        Logger.getLogger(this.getClass()).info("Nombre d'article [" 
                + pArticleId + "] : " + mStockDao.getQtyEnStock(pArticleId));
        
        /*
         * Naturellement ce test devrait tre fait avant de sortir l'article
         * du stock. Faire ce test  cet endroit permet de tester que la 
         * transaction est bien annule en cas d'exception.  
         */        
        if(mStockDao.getQtyEnStock(pArticleId) < pQty){
            Logger.getLogger(this.getClass()).info("Pas suffisament d'articles" +
                    " en stock. Lance une exception.");
            throw new NotEnoughArticleInStockException();
        }
        
	}

    
    
	/* (non-Javadoc)
     * @see net.zekey.interfaces.business.IStockService#getQtyEnStock(java.lang.String)
     */
    public int getQtyEnStock(String pArticleId) throws ArticleNotFoundException {
        
        if(!mStockDao.articleExist(pArticleId)){
            throw new ArticleNotFoundException();
        }
        
        return mStockDao.getQtyEnStock(pArticleId);
    }

    /**
	 * @return Retourne le stockDao
	 */
	public IStockDAO getStockDao() {
		return mStockDao;
	}

	/**
	 * @param pStockDao Dfinie le stockDao.
	 */
	public void setStockDao(IStockDAO pStockDao) {
		mStockDao = pStockDao;
	}

}
