package net.zekey.interfaces.business;

import net.zekey.business.exceptions.ArticleNotFoundException;
import net.zekey.business.exceptions.NotEnoughArticleInStockException;
import net.zekey.business.exceptions.QtyNegativeException;

/**
 * Dfini le service de manipulation du stock.
 *
 * @author steve.hostettler
 * 
 */
public interface IStockService {

	/**
	 * Retire la quantit donne d'article du stock.
	 * 
	 * @param pArticleId l'identifiant de l'article  retirer
	 * @param pQty la quantit d'article  retirer du stock
	 * @throws ArticleNotFoundException lance si l'article n'existe pas
	 * @throws QtyNegativeException lance si la quantit  retirer est ngative.
     * @throws NotEnoughArticleInStockException lance si la quantit  retirer 
     * est suprieur  la quantit disponible en stock.
	 */
	void sortArticleDuStock(String pArticleId, int pQty)
		throws ArticleNotFoundException,
        QtyNegativeException,
        NotEnoughArticleInStockException;
	
    /**
     * Renvoi la quantit d'article actuellement disponible en stock pour
     * cet article. l'identifiant de l'article  retirer
     * @param pArticleId
     * @return <code>int</code> quantit d'article en stock
     * @throws ArticleNotFoundException si l'article  interroger n'exite pas.
     */
    int getQtyEnStock(String pArticleId)
        throws ArticleNotFoundException;
}
