package net.zekey.interfaces.dao;

/**
 * Dfini l'object d'access aux donnes du stock.
 *
 * @author steve.hostettler
 * 
 */
public interface IStockDAO {
	
	/**
	 * Enlve une quantit donne d'article du stock.
	 * 
	 * @param pArticleId identifiant unique de l'article
	 * @param pQty la quantit d'article  enlever du stock
	 */
	void sortArticleDuStock(String pArticleId, int pQty);
	
	/**
	 * Retourne le nombre d'article de ce type en stock.
	 * 
	 * @param pArticleId identifiant unique de l'article
	 * @return int nombre d'article en stock
	 */
	int getQtyEnStock(String pArticleId);

    /**
     * Test si l'article existe
     * 
     * @param pArticleId identifiant unique de l'article
     * @return true si l'article existe, false sinon
     */
    boolean articleExist(String pArticleId);    
}
