using System;
using System.Collections.Generic;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Xml;
using System.IO;
using System.Reflection;

namespace MediaEntites {
    public class Piste {
        #region Champs
        private string _titre;
        private string _fichier;
        #endregion

        #region Accesseurs
        public string Titre {
            get {
                return _titre;
            }
        }
        public string Fichier {
            get {
                return _fichier;
            }
        }
        #endregion

        #region Construction
        public Piste(string fichier) {
            _fichier = fichier;
            FileInfo fic = new FileInfo(fichier);
            _titre = fic.Name;
        }
        #endregion

    }

    public class Album {
        #region Champs Statiques
        private static string g_largeDefaultImagePath;
        private static string g_smallDefaultImagePath;
        #endregion

        #region Champs
        private string _titre;
        private string _smallImagePath;
        private string _largeImagePath;
        private ObservableCollection<Piste> _pistes;
        #endregion

        #region Accesseurs statiques
        public static string LargeDefaultImagePath {
            get {
                return g_largeDefaultImagePath;
            }
            set {
                g_largeDefaultImagePath = value;
            }
        }
        public static string SmallDefaultImagePath {
            get {
                return g_smallDefaultImagePath;
            }
            set {
                g_smallDefaultImagePath = value;
            }
        }
        #endregion

        #region Accesseurs
        public string Titre {
            get {
                return _titre;
            }
        }
        public string SmallImagePath {
            get {
                if (_smallImagePath != null) {
                    return _smallImagePath;
                } else {
                    return g_smallDefaultImagePath;
                }
            }
        }
        public string LargeImagePath {
            get {
                if (_largeImagePath != null) {
                    return _largeImagePath;
                } else {
                    return g_largeDefaultImagePath;
                }
            }
        }
        public ObservableCollection<Piste> Pistes {
            get {
                return _pistes;
            }
        }
        public int NbPistes {
            get {
                return _pistes.Count;
            }
        }
        #endregion

        #region Construction
        // Constructeur statique : initialisation des donnes statiques
        static Album() {
            FileInfo fic = new FileInfo(Assembly.GetExecutingAssembly().Location);
            g_smallDefaultImagePath = fic.Directory.FullName + @"\UnknownSmall.png";
            g_largeDefaultImagePath = fic.Directory.FullName + @"\UnknownLarge.png";
        }

        private Album() {
            _pistes = new ObservableCollection<Piste>();
        }
        public static void ScannerRepertoire(ObservableCollection<Album> albums, DirectoryInfo repertoire) {
            // 1. On parcourt les sous-rpertoires
            foreach (DirectoryInfo sousrep in repertoire.GetDirectories()) {
                ScannerRepertoire(albums, sousrep);
            }

            // 2. On regarde si le repertoire contient lui-mme un album
            string desktopIniPath = repertoire.FullName + "\\desktop.ini";
            bool album = false;
            if (File.Exists(desktopIniPath)) {
                using (TextReader reader = File.OpenText(desktopIniPath)) {
                    string ligne;
                    while ((ligne = reader.ReadLine()) != null) {
                        if (ligne == "FolderType=MusicAlbum") {
                            album = true;
                            break;
                        }
                    }
                }
            }
            if (album) {
                Album nouveau = new Album();
                nouveau._titre = repertoire.Name;

                foreach (FileInfo imagepath in repertoire.GetFiles("AlbumArt_*")) {
                    string path = imagepath.Name.ToLower();
                    if (path.EndsWith("_small.jpg")) {
                        nouveau._smallImagePath = imagepath.FullName;
                    } else if (path.EndsWith("_large.jpg")) {
                        nouveau._largeImagePath = imagepath.FullName;
                    }
                }

                // Rcupration des pistes
                SortedList<string, Piste> pistes = new SortedList<string, Piste>();
                foreach (FileInfo piste in repertoire.GetFiles("*.wma")) {
                    pistes.Add(piste.Name, new Piste(piste.FullName));
                }

                foreach (Piste piste in pistes.Values) {
                    nouveau._pistes.Add(piste);
                }

                albums.Add(nouveau);
            }

        }

        #endregion
    }

    public class AlbumCollection : ObservableCollection<Album> {
        public AlbumCollection() {
            string rep = Environment.GetFolderPath(Environment.SpecialFolder.MyMusic);
            Album.ScannerRepertoire(this, new DirectoryInfo(rep));

        }
    }
}
