/**************************************************************************
 * 
 * (C) 2006 Alain Zanchetta - Microsoft France
 * 
 * CreeDoc : cration d'un document XPS trs simple
 * 
 **************************************************************************/

using System;
using System.IO;
using System.IO.Packaging;
using System.Windows.Xps.Packaging;
using System.Xml;
using System.Globalization;

namespace CreeDoc
{
    class Program
    {
        static string MillimetresToPoints(double millis) {
            return (millis * 96.0 / 25.4).ToString(CultureInfo.GetCultureInfo("en-US").NumberFormat);
        }

        static Uri AjouterPolice(IXpsFixedPageWriter page, string police) {
            using (XpsFont font = page.AddFont(false)) {
                byte[] contenu = File.ReadAllBytes(police);
                font.GetStream().Write(contenu, 0, contenu.Length);
                return font.Uri;
            }
        }


        static void Main(string[] args) {
            if (args.Length != 3) {
                Console.WriteLine("Usage : CreeDoc fichier.xps police message");
            } else {
                string fichier = args[0];
                string police = args[1];
                string message = args[2];

                try {
                    if (File.Exists(fichier)) {
                        File.Delete(fichier);
                    }
                    using (Package package = Package.Open(fichier)) {
                        XpsDocument documentFile = new XpsDocument(package);

                        IXpsFixedDocumentSequenceWriter sequence = documentFile.AddFixedDocumentSequence();
                        IXpsFixedDocumentWriter document = sequence.AddFixedDocument();
                        IXpsFixedPageWriter page = document.AddFixedPage();

                        Uri fontUri = AjouterPolice(page, police);

                        XmlWriter xmlWriter = page.XmlWriter;

                        xmlWriter.WriteStartElement("FixedPage");
                        xmlWriter.WriteAttributeString("xmlns", "http://schemas.microsoft.com/xps/2005/06");
                        xmlWriter.WriteAttributeString("Width", MillimetresToPoints(210.0));
                        xmlWriter.WriteAttributeString("Height", MillimetresToPoints(128.5));
                        xmlWriter.WriteAttributeString("xml:lang", "fr-FR");

                        xmlWriter.WriteStartElement("Glyphs");
                        xmlWriter.WriteAttributeString("Fill", "#ff000000");
                        xmlWriter.WriteAttributeString("FontUri", fontUri.ToString());
                        xmlWriter.WriteAttributeString("FontRenderingEmSize", "14");
                        xmlWriter.WriteAttributeString("OriginX", MillimetresToPoints(30.0));
                        xmlWriter.WriteAttributeString("OriginY", MillimetresToPoints(30.0));
                        xmlWriter.WriteAttributeString("UnicodeString", message);
                        xmlWriter.WriteEndElement();

                        xmlWriter.WriteEndElement();

                        page.Commit();
                        document.Commit();
                        sequence.Commit();
                    }
                } catch (Exception ex) {
                    Console.WriteLine("*** Exception : " + ex.Message);
                    Console.WriteLine(ex.StackTrace);
                }
            }
        }
    }
}
