/*
 * Decompiled with CFR 0.152.
 */
package pkg;

import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import pkg.Assertion;
import pkg.AssertionFailedException;
import pkg.DonneePlein;
import pkg.NokiaEssenceException;
import pkg.ToolsFiles;
import pkg.ToolsStrings;

public class Donnees {
    public static final String FichierApplication = "NokiaEssence.txt";
    public static final char FichierSeparateur = ';';
    private FileConnection mainFileConnection = null;
    public String[] voitures = null;
    public Vector pleins = null;

    private String VoituresToString() {
        String result = "";
        int i = 0;
        while (i < this.voitures.length) {
            result = String.valueOf(result) + this.voitures[i];
            if (i < this.voitures.length - 1) {
                result = String.valueOf(result) + ';';
            }
            ++i;
        }
        return result;
    }

    public void LoadFromFile() throws IOException, NokiaEssenceException, AssertionFailedException {
        FileConnection fconn = this.GetFileConnection();
        String dataStr = ToolsFiles.ReadFromFile(fconn);
        this.pleins = ToolsStrings.StringToVector(dataStr);
        if (this.pleins == null || this.pleins.size() <= 0) {
            throw new NokiaEssenceException("Les voitures ne sont pas d\u00e9finies dans le fichier");
        }
        String dataVoitures = this.pleins.elementAt(0).toString();
        this.voitures = ToolsStrings.Split(dataVoitures, ';');
        if (this.voitures == null || this.voitures.length <= 0) {
            throw new NokiaEssenceException("Aucune voitures d\u00e9finie dans le fichier");
        }
        this.pleins.removeElementAt(0);
    }

    public void SaveToFile() throws IOException, NokiaEssenceException, AssertionFailedException {
        FileConnection fconn = this.GetFileConnection();
        String strVoitures = this.VoituresToString();
        String strPleins = ToolsStrings.VectorToString(this.pleins, "\r\n");
        String dataStr = String.valueOf(strVoitures) + "\r\n" + strPleins;
        ToolsFiles.WriteToFileString(fconn, dataStr, false);
    }

    public String VoitureIntToLibelle(int aVoiture) throws AssertionFailedException {
        Assertion.Assert(aVoiture >= 0, "\"" + aVoiture + "\"<0");
        Assertion.Assert(aVoiture < this.VoitureCount(), "\"" + aVoiture + "\"<\"" + this.VoitureCount() + "\"");
        return this.voitures[aVoiture];
    }

    public int VoitureCount() {
        return this.voitures.length;
    }

    public FileConnection GetFileConnection() throws IOException, NokiaEssenceException {
        if (this.mainFileConnection == null) {
            String url = ToolsFiles.GetFileName(FichierApplication);
            this.mainFileConnection = (FileConnection)Connector.open((String)url, (int)3);
            boolean b = this.mainFileConnection.exists();
            if (!b) {
                throw new NokiaEssenceException("Le fichier \"NokiaEssence.txt\" n'existe pas. (Url =" + url + ")");
            }
            return this.mainFileConnection;
        }
        return this.mainFileConnection;
    }

    public void Add(Date aDate, double aLitres, double aKm, int aVoiture) throws IOException, AssertionFailedException, NokiaEssenceException {
        Assertion.Assert(aVoiture >= 0, "\"" + aVoiture + "\"<0");
        Assertion.Assert(aVoiture < this.VoitureCount(), "\"" + aVoiture + "\"<\"" + this.VoitureCount() + "\"");
        DonneePlein donnePlein = new DonneePlein(aDate, aLitres, aKm, aVoiture);
        this.pleins.addElement(donnePlein.toString());
        this.SaveToFile();
    }

    public void DeleteAll() throws IOException, NokiaEssenceException, AssertionFailedException {
        this.pleins.removeAllElements();
        Assertion.Assert(this.pleins.size() == 0, "pleins.size()==0");
        this.SaveToFile();
    }

    public void Delete(int aIndex) throws IOException, NokiaEssenceException, AssertionFailedException {
        Assertion.Assert(aIndex >= 0, "Delete : \"" + aIndex + "\"<0");
        Assertion.Assert(aIndex < this.pleins.size(), "Delete : \"" + aIndex + "\">=\"" + this.pleins.size() + "\"");
        this.pleins.removeElementAt(aIndex);
        this.SaveToFile();
    }
}

