/*
 * Decompiled with CFR 0.152.
 */
package pkg;

import java.io.IOException;
import java.util.Date;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import pkg.Assertion;
import pkg.AssertionFailedException;
import pkg.Donnees;
import pkg.NokiaEssenceException;
import pkg.NokiaEssenceMIDlet;
import pkg.ToolsStrings;
import pkg.VisuForm;

public class MainForm
extends Form
implements CommandListener {
    public static final String TitreApplication = "NokiaEssence v0.57";
    public static final Command commandExit = new Command("Exit", 7, 0);
    public static final Command commandOk = new Command("Ok", 4, 1);
    public static final Command commandSauver = new Command("Sauver", 8, 2);
    public static final Command commandVisualiser = new Command("Visualiser", 8, 3);
    public static final Command commandDebug = new Command("Debug", 8, 4);
    DateField dateField = new DateField("DateField", 1);
    TextField textFieldKm = new TextField("TextField", "", 50, 0);
    TextField textFieldLitres = new TextField("TextField", "", 50, 0);
    ChoiceGroup choiceGroupVoiture = new ChoiceGroup("ChoiceGroup", 1);
    public NokiaEssenceMIDlet nokiaEssenceMIDlet = null;
    public Donnees donnees = new Donnees();

    public MainForm(String p1) {
        super(p1);
    }

    public MainForm(NokiaEssenceMIDlet aNokiaEssenceMIDlet) throws Exception {
        this("");
        this.nokiaEssenceMIDlet = aNokiaEssenceMIDlet;
        this.ndsInit();
    }

    void ndsInit() throws Exception {
        this.addCommand(commandExit);
        this.addCommand(commandOk);
        this.addCommand(commandSauver);
        this.addCommand(commandVisualiser);
        this.addCommand(commandDebug);
        this.setCommandListener(this);
        this.setTitle(TitreApplication);
        this.append((Item)this.textFieldLitres);
        this.textFieldLitres.setConstraints(5);
        this.textFieldLitres.setLabel("Litres");
        this.textFieldLitres.setMaxSize(6);
        this.append((Item)this.textFieldKm);
        this.textFieldKm.setLabel("Km");
        this.textFieldKm.setMaxSize(6);
        this.textFieldKm.setConstraints(5);
        this.append((Item)this.dateField);
        this.dateField.setDate(new Date(0L));
        this.dateField.setLabel("Date");
        Date CurrDate = new Date();
        this.dateField.setDate(CurrDate);
        this.donnees.LoadFromFile();
        this.append((Item)this.choiceGroupVoiture);
        Assertion.Assert(this.donnees.VoitureCount() > 0, "Pas de voitures d\u00e9finies");
        int i = 0;
        while (i < this.donnees.VoitureCount()) {
            this.choiceGroupVoiture.append(this.donnees.VoitureIntToLibelle(i), null);
            ++i;
        }
        this.choiceGroupVoiture.setSelectedIndex(0, true);
        this.choiceGroupVoiture.setLabel("Voiture");
    }

    public double CalculTaux(double aLitres, double aKm) throws AssertionFailedException {
        Assertion.Assert(aKm != 0.0, "Division par 0 impossible");
        Assertion.Assert(aKm >= 0.01, "\"" + aKm + "\" doit \u00eatre >=0.01");
        Assertion.Assert(aKm <= 1600.0, "\"" + aKm + "\" doit \u00eatre <=1600");
        Assertion.Assert(aLitres >= 0.0, "\"" + aLitres + "\" doit \u00eatre >=0");
        Assertion.Assert(aLitres <= 100.0, "\"" + aLitres + "\" doit \u00eatre <=100");
        return aLitres * 100.0 / aKm;
    }

    public String CalculTauxIHM() throws AssertionFailedException {
        String Litres = this.textFieldLitres.getString();
        String Km = this.textFieldKm.getString();
        return this.CalculTauxStr(Litres, Km);
    }

    public double CalculTaux(String aLitres, String aKm) throws AssertionFailedException {
        double Litres = Double.parseDouble(aLitres);
        double Km = Double.parseDouble(aKm);
        return this.CalculTaux(Litres, Km);
    }

    public String CalculTauxStr(String aLitres, String aKm) throws AssertionFailedException {
        double taux = this.CalculTaux(aLitres, aKm);
        String resStr = Double.toString(taux);
        int size = Math.min(resStr.length(), 5);
        resStr = resStr.substring(0, size);
        return resStr;
    }

    public boolean Verify() {
        if (this.textFieldKm.getString().length() == 0 || this.textFieldLitres.getString().length() == 0) {
            this.nokiaEssenceMIDlet.ShowMessage("Attention", "Vous devez renseigner les champs.", AlertType.ERROR);
            return false;
        }
        double km = Double.parseDouble(this.textFieldKm.getString());
        if (km <= 0.01 || km >= 1600.0) {
            this.nokiaEssenceMIDlet.ShowMessage("Attention", "Valeur incorrecte pour Km.", AlertType.ERROR);
            return false;
        }
        double litres = Double.parseDouble(this.textFieldLitres.getString());
        if (litres <= 0.0 || litres >= 100.0) {
            this.nokiaEssenceMIDlet.ShowMessage("Attention", "Valeur incorrecte pour Litres.", AlertType.ERROR);
            return false;
        }
        return true;
    }

    public void SupprimerRecord(int aRecordIndex) throws IOException, AssertionFailedException, NokiaEssenceException {
        Assertion.Assert(aRecordIndex >= 0, "SupprimerRecord : \"" + aRecordIndex + "\"<0");
        Assertion.Assert(aRecordIndex < this.donnees.pleins.size(), "SupprimerRecord : \"" + aRecordIndex + "\">=\"" + this.donnees.pleins.size() + "\"");
        this.donnees.Delete(aRecordIndex);
        this.ActionVisualiser();
    }

    public void SupprimerTout() throws IOException, AssertionFailedException, NokiaEssenceException {
        this.donnees.DeleteAll();
        this.ActionVisualiser();
    }

    public void ShowDetaille(String aDate, String aLitres, String aKm, String aVoiture) throws AssertionFailedException {
        String Msg = String.valueOf(aDate) + "\r\n" + aLitres.toString() + " L" + "\r\n" + aKm.toString() + " Km" + "\r\n" + this.CalculTauxStr(aLitres, aKm);
        this.nokiaEssenceMIDlet.ShowMessage(aVoiture, Msg, AlertType.INFO);
    }

    public void ShowDetaille(String aRecord) throws AssertionFailedException, NokiaEssenceException {
        String[] tab = ToolsStrings.Split(aRecord, ';');
        if (tab.length != 4) {
            throw new NokiaEssenceException("Structure du fichier incorrecte : tab.length = \"" + tab.length + "\"");
        }
        String date = tab[0];
        String litres = tab[1];
        String km = tab[2];
        String voiture = tab[3];
        int voitureInt = Integer.parseInt(voiture);
        Assertion.Assert(voitureInt >= 0, "\"" + voitureInt + "\"<0");
        Assertion.Assert(voitureInt < this.donnees.VoitureCount(), "\"" + voitureInt + "\"<\"" + this.donnees.VoitureCount() + "\"");
        voiture = this.donnees.voitures[voitureInt];
        this.ShowDetaille(date, litres, km, voiture);
    }

    public void commandAction(Command aCommand, Displayable aDisplayable) {
        try {
            if (aCommand == commandExit) {
                this.nokiaEssenceMIDlet.notifyDestroyed();
            }
            if (aCommand == commandOk) {
                this.ActionOk();
            }
            if (aCommand == commandSauver) {
                this.ActionSauver();
            }
            if (aCommand == commandVisualiser) {
                this.ActionVisualiser();
            }
            if (aCommand == commandDebug) {
                this.ActionDebug();
            }
        }
        catch (Exception e) {
            this.nokiaEssenceMIDlet.ShowError(e);
        }
    }

    public void ActionOk() throws AssertionFailedException {
        if (this.Verify()) {
            String resStr = this.CalculTauxIHM();
            this.nokiaEssenceMIDlet.ShowMessage("R\u00e9sultat", resStr, AlertType.INFO);
        }
    }

    public void ActionSauver() throws IOException, AssertionFailedException, NokiaEssenceException {
        if (!this.Verify()) {
            return;
        }
        Date date = this.dateField.getDate();
        String strKm = this.textFieldKm.getString();
        String strLitres = this.textFieldLitres.getString();
        double km = Double.parseDouble(strKm);
        double litres = Double.parseDouble(strLitres);
        int voiture = this.choiceGroupVoiture.getSelectedIndex();
        this.donnees.Add(date, litres, km, voiture);
        this.nokiaEssenceMIDlet.ShowMessage("Sauvegarde", "Sauvegarde effectu\u00e9e", AlertType.INFO);
    }

    public void ActionVisualiser() throws IOException, AssertionFailedException {
        if (this.donnees.pleins.size() <= 0) {
            this.nokiaEssenceMIDlet.ShowError("Vide", "Aucune donn\u00e9e \u00e0 afficher");
            return;
        }
        String[] dataStrings = new String[this.donnees.pleins.size()];
        int i = 0;
        while (i < this.donnees.pleins.size()) {
            dataStrings[i] = this.donnees.pleins.elementAt(i).toString();
            ++i;
        }
        VisuForm visuForm = new VisuForm(dataStrings, this);
        Display.getDisplay((MIDlet)this.nokiaEssenceMIDlet).setCurrent((Displayable)visuForm);
    }

    public void ActionDebug() throws AssertionFailedException {
        this.nokiaEssenceMIDlet.ShowMessage("", "", AlertType.WARNING);
    }
}

