/*
 * Decompiled with CFR 0.152.
 */
package pkg;

import java.util.Date;
import pkg.Assertion;
import pkg.AssertionFailedException;
import pkg.ToolsStrings;

public class DonneePlein {
    Date date;
    double litre;
    double km;
    int voiture;

    public DonneePlein(Date aDate, double aLitres, double aKm, int aVoiture) throws AssertionFailedException {
        Assertion.Assert(aKm >= 0.01, "\"" + aKm + "\" doit \u00eatre >=0.01");
        Assertion.Assert(aKm <= 1600.0, "\"" + aKm + "\" doit \u00eatre <=1600");
        Assertion.Assert(aLitres >= 0.0, "\"" + aLitres + "\" doit \u00eatre >=0");
        Assertion.Assert(aLitres <= 100.0, "\"" + aLitres + "\" doit \u00eatre <=100");
        Assertion.Assert(aDate != null, "aDate!=null");
        this.date = aDate;
        this.litre = aLitres;
        this.km = aKm;
        this.voiture = aVoiture;
    }

    public DonneePlein(String aDate, String aLitre, String aKm, String aVoiture) throws AssertionFailedException {
        this.date = ToolsStrings.StrToDate(aDate);
        this.litre = Double.parseDouble(aLitre);
        this.km = Double.parseDouble(aKm);
        this.voiture = Integer.parseInt(aVoiture);
    }

    public String toString() {
        String strDate = ToolsStrings.DateToStr(this.date);
        String strLitre = "" + this.litre;
        String strKm = "" + this.km;
        String strVoiture = "" + this.voiture;
        String result = String.valueOf(strDate) + ';' + strLitre + ';' + strKm + ';' + strVoiture;
        return result;
    }
}

