package pkg;

import java.io.OutputStream;
import java.io.InputStream;
import javax.microedition.io.file.FileConnection;

public class ToolsFiles {
    // Fonctions fichiers
    public static String GetFileName (String AFileName) throws NokiaEssenceException
    {
        String url = System.getProperty("fileconn.dir.photos");

        if ((url==null) || (url=="")) {
            throw new NokiaEssenceException("fileconn.dir.photos est inconnu (ToolsFiles)");
        }else {
            return url+AFileName;
        }
    }   

    public static void WriteToFileString(FileConnection aFConn,String aStringToWrite,boolean aAppend) throws java.io.IOException,AssertionFailedException
    {
        Assertion.Assert(aFConn!=null,"WriteToFileString");
        OutputStream os;
        if (aAppend)
        {
            long filesize = aFConn.fileSize();
            os = aFConn.openOutputStream(filesize);
        }
        else
        {
            if (aFConn.exists()) aFConn.delete();
            aFConn.create();
            os = aFConn.openOutputStream();
        }
        try
        {
            os.write(aStringToWrite.getBytes());
            os.flush();
        }
        finally
        {
            os.close();
        }
    }
    
    public static String ReadFromFile(FileConnection aFConn) throws java.io.IOException,AssertionFailedException
    {
        Assertion.Assert(aFConn!=null,"ReadFromFile");
        InputStream is;
        is = aFConn.openInputStream();
        try
        {
            StringBuffer AStringToRead = new StringBuffer("");
            int i;
            i=is.read();
            while (i!=-1)
            {
                AStringToRead.append((char)i);
                i=is.read();
            }
            return AStringToRead.toString();
        }
        finally
        {
            is.close();
        }               
    }

}
