package pkg;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.List;

public class VisuForm extends List implements CommandListener {

    static public final javax.microedition.lcdui.Command commandExit = new Command("Exit", Command.EXIT, 0);
    static public final javax.microedition.lcdui.Command commandRead = new Command("Visualiser", Command.ITEM, 1);
    static public final javax.microedition.lcdui.Command commandDelete = new Command("Supprimer", Command.ITEM, 2);
    static public final javax.microedition.lcdui.Command commandDeleteAll = new Command("Supprimer tout", Command.ITEM, 3);
    
    // References de la MainForm
    private final MainForm mainForm;
    
    public VisuForm (String[] stringElements,MainForm aMainForm) throws AssertionFailedException    
    {
        // Initialisation de la liste
        super ("Liste",List.IMPLICIT,stringElements,null);
        Assertion.Assert(stringElements!=null,"stringElements!=null");
        Assertion.Assert(stringElements.length!=0,"stringElements.length!=0");
        Assertion.Assert(aMainForm!=null,"aMainForm!=null");
        mainForm = aMainForm;
        int i;
        Font f;
        f = Font.getFont(Font.FACE_SYSTEM,Font.STYLE_PLAIN,Font.SIZE_SMALL);
        for (i=0;i<stringElements.length;i++)
         {
          setFont(i,f);
         }

        // Composants de la form
        setSelectCommand(commandRead);
        addCommand(commandExit);
        addCommand(commandDelete);
        addCommand(commandDeleteAll);
        this.setCommandListener(this);
    }
    
    public void commandAction(Command command, Displayable displayable) 
    {
        try
        {
            if ( command == commandExit )      RetourMainForm();
            if ( command == commandRead )      ActionRead();
            if ( command == commandDelete )    ActionDelete();
            if ( command == commandDeleteAll ) ActionDeleteAll();
        }
         catch( Exception e ) 
         {
             mainForm.nokiaEssenceMIDlet.ShowError(e);
         }   
    }
    
    public void RetourMainForm()
    {
        Display.getDisplay( mainForm.nokiaEssenceMIDlet ).setCurrent( mainForm );
    }
    
    public void ActionRead() throws AssertionFailedException,NokiaEssenceException
    {
        String s;
        int i;
        i = getSelectedIndex();
        s = getString(i);
        mainForm.ShowDetaille(s);
    }

    public void ActionDelete() throws java.io.IOException,AssertionFailedException,NokiaEssenceException,NokiaEssenceException
    {
        int i;
        i = getSelectedIndex();
        mainForm.SupprimerRecord(i);
        if (mainForm.donnees.pleins.size()==0) RetourMainForm();
    }

    public void ActionDeleteAll() throws java.io.IOException,NokiaEssenceException,AssertionFailedException
    {
        mainForm.SupprimerTout();
        RetourMainForm();
    }
}
