<?php
$items = array();

 //Flux Atom des News de PHP.NET
 $feedPHP = 'http://fr.php.net/feed.atom';
 // lecture du flux
 $xmlPHP = simplexml_load_file($feedPHP);
 if( 0 < sizeof($xmlPHP->entry)) {
 	foreach($xmlPHP->entry as $item) {
 		// convertion de la date ATOM en TIMESTAMP
 		$atomdate = (string)$item->published;
 		$datetime = strtotime(substr($atomdate, 0, 10) . ' ' . substr($atomdate, 11, 8 ));
		$items[$datetime] = array(
					'titre'	=>	(string)$item->title,
					'descriptif'	=>	$item->content->asXml(),
					'publication'	=>	$datetime,
					'url'			=>  (string)$item->link['href']
					);
 	}
 }

 //Flux RSS des News de programmez
 $feedRSS = 'http://www.programmez.com/rss/rss_actu_intro_redir.php?xts=284128&xtor=RSS-3';
 // lecture du flux
 $feedRSS = simplexml_load_file($feedRSS);
 if( 0 < sizeof($feedRSS->channel->item)) {
	$timeZone = 'Europe/Paris';
    date_default_timezone_set($timeZone);
 	foreach($feedRSS->channel->item as $item) {
 		// convertion de la date RSS en TIMESTAMP
 		$rssdate = (string)$item->pubDate;
 		$dateTime = new DateTime($rssdate);
 		$rssdate = (mktime($dateTime->format('H'),$dateTime->format('i'),$dateTime->format('s'),$dateTime->format('m'),$dateTime->format('d'),$dateTime->format('Y')));
		$items[$rssdate] = array(
					'titre'	=>	(string)$item->title,
					'descriptif'	=>	(string)$item->description,
					'publication'	=>	$rssdate,
					'url'			=>  (string)$item->link
					);
 	}
 }

 // Tri par date du flux
 krsort($items);

// Gnration du flux agrgat
$doc = new DOMDocument('1.0', 'iso-8859-1');

// Cration du niveau racine
$node = $doc->createElement("rss");

// Ajout dun attribut pour la version du flux RSS
$node->setAttribute('version','2.0');

// Attachement du flux RSS au document
$doc->appendChild($node);

// Cration du conteneur des actualits
$nodeChannel = $doc->createElement("channel");

// Information du flux
$nodeChannelTitle = $doc->createElement("title",'Flux agreger');
$nodeChannelLink  = $doc->createElement("link",'http://www.programmez.com');
$nodeChannelDesc  = $doc->createElement("description",'Flux agreger');

// Attachement du canal
$node->appendChild($nodeChannel);

// Attachement des informations du flux
$nodeChannel->appendChild($nodeChannelTitle);
$nodeChannel->appendChild($nodeChannelLink);
$nodeChannel->appendChild($nodeChannelDesc);

if(0 < sizeof($items)) {
	// Parcours des items lut dans le flux ATOM et RSS
	foreach($items as $item) {
		// Cration de litem
		$nodeItem = $doc->createElement("item");
		$nodeChannel->appendChild($nodeItem);
		// Elments qui composent litem
		$nodeItemTitle = $doc->createElement("title",$item['titre']);
		$nodeItemLink  = $doc->createElement("link",$item['url']);
		$nodeItemDesc  = $doc->createElement("description",$item['descriptif']);
		// Insertion de la date au format RSS
		$nodeItemDate  = $doc->createElement("pubDate",date(DATE_RSS,$item['publication']));
		// Attachement des lments
		$nodeItem->appendChild($nodeItemTitle);
		$nodeItem->appendChild($nodeItemLink);
		$nodeItem->appendChild($nodeItemDesc);
		$nodeItem->appendChild($nodeItemDate);
	}
}

// Affichage du flux RSS
header ("content-type: text/xml");
echo $doc->saveXML();
