<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    version="1.0">
<!-- spcification du format de sortie -->
<xsl:output
    indent="yes"
    method="xml"
    omit-xml-declaration="no"
    encoding="iso-8859-1"
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
<xsl:output method="html"/>
<!-- rcuperation des paramtres passs par PHP -->
<xsl:param name="limit"/>
<xsl:param name="start"/>
<xsl:param name="parPage"/>
<!-- supprime les espaces -->
<xsl:strip-space elements="*" />
<!-- preserve les espaces pour les balises dfinient -->
<xsl:preserve-space elements="pre | code" />
<!-- applique le template si le pattern est trouv dans le XML -->
<xsl:template match="channel">
<html>
	<head>
		<!-- feuille de styles  -->
		<link rel="stylesheet" type="text/css" href="transform.css"/>
	</head>
	<body>
		<table>
			<thead>
				<tr>
					<th>Titre</th>
					<th>Description</th>
					<th>Url</th>
					<th>Date</th>
				</tr>
		    </thead>
		    <tfoot>
		    	<tr>
		    		<td colspan="4">
		    			<!-- appel de la fonction pagination -->
					    <xsl:call-template name="pagination">
					      <!--  paramtres passs a la fonction -->
					      <xsl:with-param name="debut" select="1" />
					      <xsl:with-param name="fin" select="count(item)" />
					    </xsl:call-template>
		       		</td>
		    	</tr>
		    </tfoot>
		    <tbody>
		    <!-- parcours des items du flux -->
		    <xsl:for-each select="item">
		    	<xsl:sort select="php:functionString('convertTimeStamp', string(pubDate))" data-type="number" order="ascending"/>
		    	<!--  limitation de l'affichage entre d'une limite basse et d'une limite basse -->
		    	<xsl:if test="position() &gt; $start and position() &lt;= $limit ">
		 		<tr>
		 			<!-- affiche les information de l'item -->
			        <td><a href="{link}"><xsl:value-of select="title"/></a></td>
			        <td><xsl:value-of select="description"/></td>
			        <td><xsl:value-of select="link"/></td>
			        <td><xsl:value-of select="php:functionString('convertDate', string(pubDate))"/></td>
		        </tr>
		        </xsl:if>
		    </xsl:for-each>
		    </tbody>
		</table>
	</body>
</html>
</xsl:template>

<!-- fonction pour la pagination -->
<xsl:template name="pagination">
  <!-- parametres de la fonction -->
  <xsl:param name="debut" select="0" />
  <xsl:param name="fin" select="0" />
  <!--  affichage du lien -->
  <a href="?page={$debut}"><xsl:value-of select="$debut" /></a>
  <!-- separateur -->
  <xsl:text> | </xsl:text>
  <xsl:if test="$debut &lt; ceiling($fin div $parPage)">
  	<!-- rappel de la fonction pagination -->
    <xsl:call-template name="pagination">
      <xsl:with-param name="debut" select="($debut)+1" />
      <xsl:with-param name="fin" select="$fin" />
    </xsl:call-template>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>