<?php

date_default_timezone_set('Europe/Paris');
// Conversion de la date au format Fr
function convertDate($pubDate) {
	$dateTime = new DateTime($pubDate);
	return $dateTime->format('H:i:s d/m/Y');
}
// conversion de la date au format Timestamp
function convertTimeStamp($date) {
	$dateTime = new DateTime($date);
	return mktime($dateTime->format('H'),$dateTime->format('i'),$dateTime->format('s'),$dateTime->format('m'),$dateTime->format('d'),$dateTime->format('Y'));
}

// Flux RSS des News de programmez
$feedRSS = 'http://www.programmez.com/rss/rss_actu_intro_redir.php?xts=284128&xtor=RSS-3';
// Chargement du flux RSS
$chan = new DOMDocument();
$chan->load($feedRSS);
// Chargement de la transformation XSL
$sheet = new DOMDocument();
$sheet->load('table.xsl');
// Gestion de la pagination
$page = !empty($_GET['page']) ? $_GET['page'] - 1 : 0;
$parPage = 4;
// Dfinition des limites daffichages
$start = $page*$parPage;
$limit = $start + $parPage;
// Instantiation du moteur XSL
$processor = new XSLTProcessor();
// Import du modele
$processor->importStylesheet($sheet);
// Passage des variables PHP au XSL
$processor->setParameter(null, 'limit', $limit );
$processor->setParameter(null, 'start', $start );
$processor->setParameter(null, 'parPage', $parPage );
// Enregistrement des fonctions PHP
$processor->registerPhpFunctions();
// Transformation du XML avec le feuille XSL
echo $processor->transformToXML($chan);
