using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.IO;

namespace ServeurRandom
{
	public partial class Form1 : Form
	{
		private bool IsRunning;
		private Thread thread;
		private Socket serveur_socket;

		public Form1()
		{
			InitializeComponent();
		}

		private void ServeurWorker()
		{
			Random random = new Random();
			try
			{
				while (true)
				{
					serveur_socket.Listen(10);

					Socket socket = serveur_socket.Accept();
					NetworkStream ns = new NetworkStream(socket);
					StreamWriter sw = new StreamWriter(ns);

					Double d = random.NextDouble();
					String s = "" + d;

					sw.WriteLine(s);

					sw.Close();
					socket.Disconnect(false);
				}
			}
			catch (SocketException)
			{
				// serveur_socket.Close() va lever cette exception
			}
		}

		private void button1_Click(object sender, EventArgs e)
		{
			IPHostEntry ipHostInfo = Dns.GetHostEntry("localhost");
			IPAddress ipAddress = ipHostInfo.AddressList[0];
			IPEndPoint localEndPoint = new IPEndPoint(ipAddress, 8000);

			serveur_socket = new Socket(AddressFamily.InterNetwork,
				SocketType.Stream, ProtocolType.Tcp);

			serveur_socket.Bind(localEndPoint);

			thread = new Thread(ServeurWorker);
			thread.Start();
			textBox1.Text = "Serveur dmarr" + Environment.NewLine;
			IsRunning = true;
			button1.Enabled = false;
			button2.Enabled = true;
		}

		private void button2_Click(object sender, EventArgs e)
		{
			serveur_socket.Close();
			IsRunning = false;
			button1.Enabled = true;
			button2.Enabled = false;
			textBox1.Text = "Serveur arrt" + Environment.NewLine;
		}

		private void Form1_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (IsRunning)
			{
				MessageBox.Show("Arrter le serveur avant de quitter");
				e.Cancel = true;
			}
		}
	}
}