Public Class FormSaisieNom

    Private pDossier As String
    Private pExtension As String

    Private pFilename As String
    Public ReadOnly Property Filename() As String
        Get
            Return pFilename
        End Get
    End Property

    Public Sub New(ByVal wDossier As String, ByVal wPhotoName As String)

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.

        REM Stockage des infos de base concernant la nouvelle photo
        pDossier = wDossier
        pExtension = System.IO.Path.GetExtension(wPhotoName)

        REM Calcul de la taille du conteneur photo
        Dim wTaille As Integer = PIC_Photo.Width
        If PIC_Photo.Height < wTaille Then wTaille = PIC_Photo.Height
        wTaille = wTaille - (wTaille * 0.1)

        REM Cration de la vignette correspondant  la photo
        PIC_Photo.Image = GetThumbnail(wPhotoName, wTaille, wTaille)

    End Sub

    Private Sub MEN_Annuler_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MEN_Annuler.Click

        Me.DialogResult = Windows.Forms.DialogResult.Cancel

    End Sub

    Private Sub MEN_Valider_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MEN_Valider.Click

        REM On cache le SIP au cas o
        gSIP.Enabled = False

        REM On compose le nom du fichier 
        Try
            pFilename = System.IO.Path.Combine(pDossier, TXT_NomPhoto.Text & pExtension)
        Catch
            MsgBox("Nom de fichier incorrect !", MsgBoxStyle.Exclamation)
            Exit Sub
        End Try

        If System.IO.File.Exists(pFilename) Then

            REM Le fichier existe dj, on refuse la validation
            MsgBox("Le fichier existe dj !", MsgBoxStyle.Exclamation)

        Else

            REM Validation accepte
            Me.DialogResult = Windows.Forms.DialogResult.OK

        End If

    End Sub


    Private Sub TXT_NomPhoto_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TXT_NomPhoto.TextChanged

        MEN_Valider.Enabled = (TXT_NomPhoto.Text <> "")

    End Sub
End Class