Module MainModule

    Public gFormMain As FormMain
    Public gDossierRacine As String
    Public gSIP As Microsoft.WindowsCE.Forms.InputPanel

    Public Sub Main()

        REM Cration d'une occurence de la fentre principale
        gFormMain = New FormMain

        REM Cration d'un occurence globale du SIP
        gSIP = New Microsoft.WindowsCE.Forms.InputPanel

        REM Le dossier racine est "\AlbumPhoto"
        gDossierRacine = "\AlbumPhoto"

        REM S'il n'existe pas il faut le crer
        REM Si on ne peut pas le crer, impossible d'aller plus loin
        If Not System.IO.Directory.Exists(gDossierRacine) Then
            Try
                System.IO.Directory.CreateDirectory(gDossierRacine)
            Catch ex As Exception
                MsgBox("Impossible de crer le dossier de base de l'album photos !", MsgBoxStyle.Critical)
                MsgBox(String.Format("Erreur: {0}", ex.Message))
                MsgBox("Impossible de continuer.", MsgBoxStyle.Critical)
                Exit Sub
            End Try
        End If

        REM On charge l'arborescence de l'album
        gFormMain.ChargerArborescence()

        REM On lance l'application
        Application.Run(gFormMain)

    End Sub

    Public Function GetThumbnail(ByVal wFileImage As String, ByVal wNewWidth As Integer, ByVal wNewHeight As Integer) As Bitmap

        Dim wWidth As Integer
        Dim wHeight As Integer
        Dim wThunbnail As Bitmap
        Dim wBitmap As Bitmap

        wBitmap = New Bitmap(wFileImage)

        If wBitmap.Width > wBitmap.Height Then
            wWidth = wNewWidth
            wHeight = wNewHeight * (wBitmap.Height / wBitmap.Width)
        Else
            wHeight = wNewHeight
            wWidth = wNewWidth * (wBitmap.Width / wBitmap.Height)
        End If

        wThunbnail = New Bitmap(wWidth, wHeight)
        Dim g As Graphics = Graphics.FromImage(wThunbnail)

        Dim wRecSource As New Rectangle(0, 0, wBitmap.Width, wBitmap.Height)
        Dim wRecDestination As New Rectangle(0, 0, wWidth, wHeight)
        g.DrawImage(wBitmap, wRecDestination, wRecSource, GraphicsUnit.Pixel)
        g.DrawRectangle(New Pen(Color.Black), 0, 0, wWidth - 1, wHeight - 1)
        g.Dispose()
        wBitmap.Dispose()

        Return wThunbnail

    End Function

End Module
