import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/**
 * Classe de dmonstration de la nouvelle fonctionnalit de Mustang Beta
 * concernant les le framework de scripting pour le magazine Programmez! n85 du
 * mois d'avril.
 * 
 * @author Julien Chable
 */
public class ScriptEngineTest {

	public static void main(String[] args) {
		listScriptEngineFactory();
		testJavaScriptEngine();
	}

	/**
	 * 
	 */
	private static void testJavaScriptEngine() {
		ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
		// Obtention d'un 
		ScriptEngine jsEngine = scriptEngineManager.getEngineByName("js");
		try {
			Integer a = 20;
			jsEngine.put("a", a);
			jsEngine.put("b", 5);
			jsEngine.put("val", null);
			jsEngine.eval("val = a + b;");
			System.out.println("a + b = " + jsEngine.get("val"));
		} catch (ScriptException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Permet de lister toutes les fabriques de moteur de script et d'afficher
	 * les langages associs.
	 */
	private static void listScriptEngineFactory() {
		ScriptEngineManager seManager = new ScriptEngineManager();
		List<ScriptEngineFactory> lsEngineFact = seManager.getEngineFactories();
		for (ScriptEngineFactory engineFact : lsEngineFact) {
			System.out.println("Moteur '" + engineFact.getEngineName()
					+ "' pour langage : " + engineFact.getLanguageName());
		}
	}
}
