import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.SplashScreen;

/**
 * Classe de dmonstration de la nouvelle fonctionnalit de Mustang Beta
 * concernant les fentres de dmarrage pour le magazine Programmez! n85 du
 * mois d'avril.
 * 
 * @author Julien Chable
 */
public class SplashDemo {

	// Les messages fictifs qui s'afficheront sur le splashscreen
	private String[] messages = { "Initialisation", "Chargement module",
			"Lancement" };

	public SplashDemo() {
		// On rcupre l'unique instance de SplashScreen
		SplashScreen splash = SplashScreen.getSplashScreen();
		// On rcupre l'objet Graphics associ
		Graphics2D g = (Graphics2D) splash.getGraphics();
		// Simulation du chargement de l'application
		for (int i = 0; i < 100; i += 2) {
			renderSplash(g, i, messages[i % 3]);
			// On met  jour l'affichage de la fentre de dmarrage
			splash.update();
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
			}
		}
		// Fermeture du splash screen
		splash.close();
	}

	/**
	 * Effectue le rendu sur la fentre de dmarrage
	 * 
	 * @param g
	 *            L'objet Graphic associ  la fentre de dmarrage.
	 * @param percentage
	 *            Le pourcentage de compltion du chargement, sert pour la barre
	 *            de progression.
	 * @param message
	 *            Le message qui permet de spcifier l'action de chargement en
	 *            cours
	 */
	public void renderSplash(Graphics2D g, int percentage, String message) {
		// On efface ce que l'on avait dessiner prcdemment
		g.setComposite(AlphaComposite.Clear);
		g.fillRect(10, 240, 250, 40);
		// On dessine le message et la barre de progression
		g.setPaintMode();
		g.setColor(Color.BLUE);
		g.drawString(message + " en cours ...", 10, 255);
		g.fillRect(10, 265, (int) (percentage * 2), 20);
	}

	public static void main(String[] args) {
		// Lancement de l'application de dmo
		new SplashDemo();
	}
}