Public Class ClassGPS

    Public ReadOnly Property IsRunning() As Boolean
        Get
            Return pSerialPort.IsOpen
        End Get
    End Property

    Public Event NewTrame(ByVal wTrame As String)
    Public Event NewInfoRMC(ByVal wInfo As InfoRMC)
    Public Event ExeptionOccurs(ByVal wExeption As Exception)
    Public Event TimeoutOccurs()

    Private pBuffer As String
    Private pLastReception As Long

    Private pTimeout As Integer
    Public Property Timeout() As Integer
        Get
            Return pTimeout
        End Get
        Set(ByVal value As Integer)
            pTimeout = value
        End Set
    End Property

    Private pInterval As Integer
    Public Property Interval() As Integer
        Get
            Return pInterval
        End Get
        Set(ByVal value As Integer)
            pInterval = value
            Dim wFlag As Boolean = pTimer.Enabled
            pTimer.Enabled = False
            pTimer.Interval = value
            pTimer.Enabled = False
        End Set
    End Property

    Private pPortName As String
    Public Property PortName() As String
        Get
            Return pPortName
        End Get
        Set(ByVal value As String)
            pPortName = value
        End Set
    End Property

    Private pBaudRate As Integer
    Public Property BaudRate() As Integer
        Get
            Return pBaudRate
        End Get
        Set(ByVal value As Integer)
            pBaudRate = value
        End Set
    End Property

    Private WithEvents pSerialPort As System.IO.Ports.SerialPort
    Private WithEvents pTimer As System.Windows.Forms.Timer

    Private Shared Function ToUnit(ByVal wDeg As Integer, ByVal wMin As Integer, ByVal wSec As Integer) As Single

        Return ((wDeg * 60.0! + wMin) * 1000.0! + wSec) / 10.0!

    End Function


    Public Sub New()

        pPortName = "COM1"
        pBaudRate = 4800
        pInterval = 500
        pTimeout = 5000

        pSerialPort = New System.IO.Ports.SerialPort
        pTimer = New System.Windows.Forms.Timer

    End Sub

    Public Sub Start()

        If Not pSerialPort.IsOpen Then

            pTimer.Enabled = False

            With pSerialPort
                .PortName = pPortName
                .BaudRate = pBaudRate
                .Parity = IO.Ports.Parity.None
                .DataBits = 8
                .StopBits = IO.Ports.StopBits.One
            End With

            Try
                pSerialPort.Open()
            Catch ex As Exception
                RaiseEvent ExeptionOccurs(ex)
                Exit Sub
            End Try

        End If

        pLastReception = 0

        pTimer.Interval = pInterval
        pTimer.Enabled = True

    End Sub

    Public Sub [Stop]()

        pTimer.Enabled = False
        If pSerialPort.IsOpen Then pSerialPort.Close()

    End Sub

    Private Function CheckTrame(ByRef wTrameReference As String) As Boolean

        If wTrameReference = "" Then Return False

        Dim wTrame As String = wTrameReference

        REM La trame doit commencer par $
        If wTrame.Chars(0) <> "$"c Then Return False

        REM Le *CS doit tre prsent
        If wTrame.Substring(wTrame.Length - 3, 1) <> "*" Then Return False

        REM Calcul du CS
        Dim wCS As Integer
        For i As Integer = 1 To wTrame.Length - 4
            wCS = wCS Xor Asc(wTrame.Chars(i))
        Next
        Dim wHCS As String = Hex(wCS)
        If wHCS.Length < 2 Then wHCS = "0" & wHCS

        REM Si le CS calcul est <> du CS donn
        If wHCS <> wTrame.Substring(wTrame.Length - 2, 2) Then Return False

        REM On enlve le $ de dbut et le CS de fin
        wTrameReference = wTrame.Substring(1, wTrame.Length - 4)

        REM Tout va bien
        Return True

    End Function

    Protected Overrides Sub Finalize()

        If pSerialPort.IsOpen Then pSerialPort.Close()
        pSerialPort.Dispose()

        If pTimer.Enabled Then pTimer.Enabled = False
        pTimer.Dispose()

        MyBase.Finalize()

    End Sub

    Private Sub pTimer_Tick(ByVal sender As Object, _
        ByVal e As System.EventArgs) _
        Handles pTimer.Tick

        If pSerialPort.IsOpen Then

            If pLastReception = 0 Then

                pLastReception = System.Environment.TickCount

            Else

                Dim wInterval As Long = _
                    System.Environment.TickCount - pLastReception

                If wInterval > pTimeout Then
                    pLastReception = System.Environment.TickCount
                    RaiseEvent TimeoutOccurs()
                End If

            End If

            Dim wTrame As String
            Dim k As Integer

            Try
                pBuffer &= pSerialPort.ReadExisting()
            Catch ex As Exception
                pTimer.Enabled = False
                pSerialPort.Close()
                RaiseEvent ExeptionOccurs(ex)
                Exit Sub
            End Try

            If pBuffer <> "" Then

                Do

                    k = pBuffer.IndexOf(vbCrLf)
                    If k = -1 Then Exit Do

                    wTrame = pBuffer.Substring(0, k)
                    pBuffer = pBuffer.Substring(k + 2)

                    If CheckTrame(wTrame) Then

                        pLastReception = _
                            System.Environment.TickCount

                        RaiseEvent NewTrame(wTrame)

                        Select Case wTrame.Substring(0, 6)

                            Case "GPRMC,"
                                Dim wInfoRMC As InfoRMC
                                Try
                                    wInfoRMC = New InfoRMC(wTrame)
                                Catch
                                End Try
                                If wInfoRMC IsNot Nothing Then
                                    RaiseEvent NewInfoRMC(wInfoRMC)
                                End If

                        End Select

                    End If

                Loop

            End If

        End If

    End Sub


#Region "Classes Internes"

    Public Class InfoRMC

        REM RMC = Recommended minimum specific GPS/Transit data

        Public DateFix As String
        Public HeureFix As String
        Public Alerte As String
        Public Latitude As Single
        Public Longitude As Single
        Public Vitesse As Single

        Public GpsTrame As String

        Public Sub New()

        End Sub

        Public Sub New(ByVal wTrame As String)

            REM Liste des lements composant une trame RMC
            REM 00  GPRMC()
            REM 01  Heure du fix
            REM 02  Alerte (A=OK ; V=WARNIG)
            REM 03  Latitude au format ddmm.ss
            REM 04  Sens de la latitude (N=Nord=Positif, S=Sud=Ngatif)
            REM 05  Longitude au format dddmm.ss
            REM 06  Sens de la longitude (E=Est=Positif, W=Ouest=Ngatif)
            REM 07  Vitesse au sol en Knots (noeuds)
            REM 08  Cap vrai
            REM 09  Date du fix
            REM 10  Dclinaison magntique
            REM 11  Sens de la dclinaison magntique 

            Me.GpsTrame = wTrame

            Dim wItems() As String

            REM On clate les diffrents lments de la trame
            wItems = wTrame.Split(","c)

            REM La trame doit faire 10 lments
            If wItems.Length < 12 Then Throw New ArgumentException

            REM Le premier lement doit tre "GPRMC", Sinon Erreur
            If wItems(0) <> "GPRMC" Then Throw New ArgumentException

            REM DateFix
            Me.DateFix = wItems(9)

            REM HeureFix
            Me.HeureFix = wItems(1)

            REM Alerte
            Me.Alerte = wItems(2)

            REM Vitesse
            Try
                Me.Vitesse = Single.Parse(wItems(7).Replace(".", ",")) * 1.853184!
            Catch
            End Try

            REM Calcul de la longitude et de la latitude

            Dim wDeg As Integer
            Dim wMin As Integer
            Dim wSec As Integer

            REM Latitude (format attendu = ddmm.ssss ou ddmm.sss), sens N ou S
            If (wItems(3) Like "####.####" _
                    OrElse wItems(3) Like "####.###") _
                AndAlso (wItems(4) = "N" _
                    OrElse wItems(4) = "S") Then

                wDeg = Integer.Parse(wItems(3).Substring(0, 2))
                wMin = Integer.Parse(wItems(3).Substring(2, 2))
                wSec = Integer.Parse(wItems(3).Substring(5, 4))

                Me.Latitude = ToUnit(wDeg, wMin, wSec)
                If wItems(4) = "S" Then Me.Latitude = -Me.Latitude

            End If

            REM Longitude (format attendu = dddmm.ssss ou dddmm.sss), sens E ou W
            If (wItems(5) Like "#####.####" _
                    OrElse wItems(5) Like "#####.###") _
                AndAlso (wItems(6) = "E" _
                OrElse wItems(6) = "W") Then

                wDeg = Integer.Parse(wItems(5).Substring(0, 3))
                wMin = Integer.Parse(wItems(5).Substring(3, 2))
                wSec = Integer.Parse(wItems(5).Substring(6, 4))

                Me.Longitude = ToUnit(wDeg, wMin, wSec)
                If wItems(6) = "W" Then Me.Longitude = -Me.Longitude

            End If

        End Sub

    End Class

#End Region

End Class
