﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;
using DocumentFormat.OpenXml;
using System.Diagnostics;

namespace TimeSDKOOXML
{
    class Program
    {
        static void Main(string[] args)
        {
            Stopwatch t = new Stopwatch();
            Console.WriteLine("Debut generation ...");
            t.Start();
            for (int i = 0; i < 1000; ++i)
            {
                using (WordprocessingDocument package = WordprocessingDocument.Create("demo" + i + ".docx", WordprocessingDocumentType.Document))
                {
                    // Ajouter une partie de contenu au document 
                    package.AddMainDocumentPart();

                    // Créer le contenu de votre document 
                    package.MainDocumentPart.Document =
                        new Document(
                            new Body(
                                new Paragraph(
                                    new Run(
                                        new Text("Hello World !")))));

                    // Enregistrer le contenu dans le document 
                    package.MainDocumentPart.Document.Save();
                }
            }
            t.Stop();
            Console.WriteLine("... fin generation !");
            Console.WriteLine("Duree de generation : {0}", t.ElapsedMilliseconds);
        }
    }
}
