﻿using StationMeteo.Classes;
using StationMeteo.ViewModels;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using System.Threading.Tasks;
using Windows.Devices.Enumeration.Pnp;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Graphics.Display;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// Pour en savoir plus sur le modèle d'élément Page vierge, consultez la page http://go.microsoft.com/fwlink/?LinkId=234238

namespace StationMeteo
{
    /// <summary>
    /// Une page vide peut être utilisée seule ou constituer une page de destination au sein d'un frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPageViewModel ViewModel
        {
            get { return this.DataContext as MainPageViewModel; }
            set { this.DataContext = value; }
        }

        private PnpObjectWatcher watcher;

        public MainPage()
        {
            this.InitializeComponent();
            this.NavigationCacheMode = NavigationCacheMode.Required;

            Windows.Phone.UI.Input.HardwareButtons.BackPressed += HardwareButtons_BackPressed;

            DisplayInformation.AutoRotationPreferences = DisplayOrientations.Portrait;
        }

        void HardwareButtons_BackPressed(object sender, Windows.Phone.UI.Input.BackPressedEventArgs e)
        {

        }

        protected override async void OnNavigatedTo(NavigationEventArgs e)
        {
            var viewModel = new MainPageViewModel();

            if (await viewModel.Init())
            {
                this.ViewModel = viewModel;
            }
            else
            {
                watcher = PnpObject.CreateWatcher(PnpObjectType.DeviceContainer, new string[] { "System.Devices.Connected" }, String.Empty);
                watcher.Updated += watcher_Updated;
                watcher.Start();
            }
        }

        async void watcher_Updated(PnpObjectWatcher sender, PnpObjectUpdate args)
        {
            watcher.Stop();

            await this.Dispatcher.RunAsync(Windows.UI.Core.CoreDispatcherPriority.Normal, async () =>
                {
                    await Task.Delay(5000);
                    var viewModel = new MainPageViewModel();
                    await viewModel.Init();
                    this.ViewModel = viewModel;
                });
        }

        async private void BouConnexion_Tapped(object sender, TappedRoutedEventArgs e)
        {
            BouConnexion.Visibility = Windows.UI.Xaml.Visibility.Collapsed;

            var viewModel = this.ViewModel;
            this.ViewModel = null;

            await viewModel.Init();
            this.ViewModel = viewModel;

            BouConnexion.Visibility = Windows.UI.Xaml.Visibility.Visible;
        }
    }
}
