
#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
#endregion

namespace XnaDemo3D
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        ContentManager content;

        Model _modele;
        private Vector3 Position = Vector3.One;
        private float Zoom = 2500;
        private float RotationY = 0.0f;
        private float RotationX = 0.0f;
        private Matrix MyWorldRotation;


        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            content = new ContentManager(Services);
        }


        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }


        /// <summary>
        /// Load your graphics content.  If loadAllContent is true, you should
        /// load content from both ResourceManagementMode pools.  Otherwise, just
        /// load ResourceManagementMode.Manual content.
        /// </summary>
        /// <param name="loadAllContent">Which type of content to load.</param>
        protected override void LoadGraphicsContent(bool loadAllContent)
        {
            if (loadAllContent)
            {
                ContentManager loader = new ContentManager(Services);
                _modele = loader.Load<Model>(@"Modeles\p1_rocket");
                float facteur = 900.0F;
                if (_modele.Meshes.Count > 0)
                {
                    float radius = _modele.Meshes[0].BoundingSphere.Radius;
                    Zoom *= (facteur / radius);
                }
            }

            // TODO: Load any ResourceManagementMode.Manual content
        }


        /// <summary>
        /// Unload your graphics content.  If unloadAllContent is true, you should
        /// unload content from both ResourceManagementMode pools.  Otherwise, just
        /// unload ResourceManagementMode.Manual content.  Manual content will get
        /// Disposed by the GraphicsDevice during a Reset.
        /// </summary>
        /// <param name="unloadAllContent">Which type of content to unload.</param>
        protected override void UnloadGraphicsContent(bool unloadAllContent)
        {
            if (unloadAllContent == true)
            {
                content.Unload();
            }
        }

        private void UpdateGamePad()
        {
            GamePadState state = GamePad.GetState(PlayerIndex.One);
            KeyboardState keyboardState = Keyboard.GetState();

            if (state.Buttons.A == ButtonState.Pressed)
                Exit();

            Position.X += state.ThumbSticks.Left.X * 10;
            Position.Y += state.ThumbSticks.Left.Y * 10;
            Zoom += state.ThumbSticks.Right.Y * 10;
            if (keyboardState.IsKeyDown(Keys.Up))
            {
                Zoom += 5;
            }
            else if (keyboardState.IsKeyDown(Keys.Down))
            {
                Zoom -= 5;
            }
            RotationY += state.ThumbSticks.Right.X;
            if (keyboardState.IsKeyDown(Keys.Left))
            {
                RotationY--;
            }
            else if (keyboardState.IsKeyDown(Keys.Right))
            {
                RotationY++;
            }
            if (state.DPad.Up == ButtonState.Pressed)
                RotationX += 1.0f;
            else if (state.DPad.Down == ButtonState.Pressed)
                RotationX -= 1.0f;
            MyWorldRotation = Matrix.CreateRotationX(MathHelper.ToRadians(RotationX)) *
                Matrix.CreateRotationY(MathHelper.ToRadians(RotationY));
        }




        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the default game to exit on Xbox 360 and Windows
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();


            UpdateGamePad();


            base.Update(gameTime);
        }

        private void DrawModel(Model m)
        {
            Matrix[] transforms = new Matrix[m.Bones.Count];
            float aspectRatio = 640.0f / 480.0f;
            m.CopyAbsoluteBoneTransformsTo(transforms);
            Matrix projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.ToRadians(45.0f), aspectRatio, 1.0f, 10000.0f);
            Matrix view = Matrix.CreateLookAt(new Vector3(0.0f, 50.0f, Zoom), Vector3.Zero, Vector3.Up);

            foreach (ModelMesh mesh in m.Meshes)
            {
                foreach (BasicEffect effect in mesh.Effects)
                {
                    effect.EnableDefaultLighting();

                    effect.View = view;
                    effect.Projection = projection;
                    effect.World = MyWorldRotation * mesh.ParentBone.Transform * Matrix.CreateTranslation(Position);
                }
                mesh.Draw();
            }
        }
        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            DrawModel(_modele);

            base.Draw(gameTime);
        }
    }
}