//#define TESTHOLE
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace XnaPanic
{
    public enum GridItem { Ground, Brick, Scale, Empty, Hole1, Hole2, Hole3, Monster3, Monster2, Monster1, MonsterLeaving };

    public class Grid
    {


#region GridDefinitions
        static string[] Definition1 = {
            "BSBBBBSBBBBBBBBBSBBBBBSB",
            "BSBBBBSBBBSBBBBBSBBBBBSB",
            "BSBBBBBBBBSBBBBBBBBBBBSB",
            "BSBBBBBBBBSBBBBBSBBBBBSB",
            "BSBBBBBSBBBBBBBBSBBBBBSB",
            "BSBBBBBSBBBBBBBBSBBBBBSB"
        };
        static string[] Definition2 = {
            "BSBBBBBBBSBBBBBBBBSBBBBB",
            "BSBBSBBBBSBBBBBBBBSBBBBB",
            "BBBBSBBBBSBBBBBBBBSBBBSB",
            "BSBBSBBBBSBBBSBBBBBBBBSB",
            "BSBBBBBBBBBBBSBBBBSBBBSB",
            "BSBBBBBBBBBBBSBBBBSBBBBB"
        };
        static string[] Definition3 = {
            "BSBBBBBSBBBBBBBBBBBBBBSB",
            "BSBBSBBSBBBBBBBBSBBBBBSB",
            "BBBBSBBBBBBBSBBBSBBSBBSB",
            "BBBBSBBSBBBBSBBBBBBSBBBB",
            "BSBBBBBSBBBBSBBBSBBSBBSB",
            "BSBBBBBBBBBBBBBBSBBBBBSB"
        };
        static string[] Definition4 = {
            "BSBBBBBBBBSBBBBBBBBBBBSB",
            "BSBBSBBBBBSBBBBBBBBBBBSB",
            "BBBBSBBBBBSBBBBBSBBBBBSB",
#if TESTHOLE
            "BSHBSBBSBBBBBBBBSBBBBBSB",
#else
            "BSBBSBBSBBBBBBBBSBBBBBSB",
#endif
            "BSBBBBBSBBBBBSBBSBBSBBBB",
            "BSBBBBBBBBBBBSBBBBBSBBBB"
        };
        static string[][] GridDefinitions = { Definition1, Definition2, Definition3, Definition4 };

        #endregion

        #region Private data
        private int[] _deltas;
        private MultiTextureSprite _debugSprite;
        private MultiTextureSprite _bricks;
        private MultiTextureSprite _ground;
        private MultiTextureSprite _scale;
        private MultiTextureSprite _hole;
        private GridItem[,] _items;
        private Monster[,] _monsters;

        private ISoundService _soundService;

        // For debug
        private bool _debugDraw = false;
        #endregion

        #region Construction
        public Grid(Game game)
        {
            _soundService = (ISoundService)game.Services.GetService(typeof(ISoundService));
            _deltas = new int[3];
            _deltas[(int)SpriteHorizontalAlignment.Left] = 0;
            _deltas[(int)SpriteHorizontalAlignment.Center] = Constants.CellWidth / 2;
            _deltas[(int)SpriteHorizontalAlignment.Right] = Constants.CellWidth;
        }
        #endregion

        public void LoadGraphicsContent(ContentManager content, int width, int height)
        {
            _bricks = new MultiTextureSprite(SpriteHorizontalAlignment.Left, SpriteVerticalAlignment.Top, content, @"Sprites\Grid", "Brick");
            _ground = new MultiTextureSprite(SpriteHorizontalAlignment.Left, SpriteVerticalAlignment.Top, content, @"Sprites\Grid", "Ground");
            _scale = new MultiTextureSprite(SpriteHorizontalAlignment.Center, SpriteVerticalAlignment.Bottom, content, @"Sprites\Grid", "Scale");
            _hole = new MultiTextureSprite(SpriteHorizontalAlignment.Left, SpriteVerticalAlignment.Top, content, @"Sprites\Grid", "Hole1", "Hole2", "Hole3");
            _debugSprite = new MultiTextureSprite(SpriteHorizontalAlignment.Left, SpriteVerticalAlignment.Top, content, @"Sprites\Debug", 
                "DebugGround", "DebugBrick", "DebugScale", "DebugEmpty", "DebugHole1", "DebugHole2", "DebugHole3", "DebugMonster", "DebugMonster", "DebugMonster", "DebugMonster");

            _items = new GridItem[Constants.Width, Constants.LogicalHeight + 1];
            _monsters = new Monster[Constants.Width, Constants.LogicalHeight + 1];
        }

        public void StartLevel()
        {
            Random rnd = new Random();
            LoadGridItems(GridDefinitions[rnd.Next(GridDefinitions.Length)]);
            for (int col = 0; col < Constants.Width; col++)
            {
                for (int lig = 0; lig < Constants.LogicalHeight; lig++)
                {
                    _monsters[col, lig] = null;
                }
            }
        }

#if TESTHOLE
        static int gudule = 0;
#endif
        public void Update(GamePadState gamepad, KeyboardState keyboard, GameTime gameTime)
        {
            _debugDraw = (gamepad.Triggers.Left == 1.0);
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            if (_debugDraw)
            {
#if true
                for (int col = 0; col < Constants.Width; col++)
                {
                    for (int lig = 0; lig < Constants.LogicalHeight; lig++)
                    {
                        _debugSprite.TextureIndex = (int)_items[col, lig];
                        _debugSprite.Y = GetY(3 * lig);
                        _debugSprite.X = GetX(col, _debugSprite.HorizontalAlignment);
                        _debugSprite.Draw(spriteBatch);
                    }
                }
#else
                _scale.X = 14;
                _scale.Y = 828;
                _scale.Draw(spriteBatch);
#endif
            }
            else
            {
                // 0. Draw the ground
                _ground.Y = GetY(0);
                for (int col = 0; col < Constants.Width; col += 4)
                {
                    _ground.X = GetX(col, _ground.HorizontalAlignment);
                    _ground.Draw(spriteBatch);
                }
                // 1. Draw the bricks
                for (int line = 12; line < Constants.PhysicalHeight; line += 12)
                {
                    for (int col = 0; col < Constants.Width; col += 4)
                    {
                        _bricks.X = GetX(col, _bricks.HorizontalAlignment);
                        _bricks.Y = GetY(line);
                        _bricks.Draw(spriteBatch);
                    }
                }
                // 2. Draw the scales and holes
                for (int lig = 0; lig < Constants.LogicalHeight; lig++)
                {
                    int nextHole = 0;
                    for (int col = 0; col < Constants.Width; col++)
                    {
                        switch (_items[col, lig])
                        {
                            case GridItem.Scale:
                                _scale.TextureIndex = 0;
                                _scale.Y = GetY(lig * 3);
                                _scale.X = GetX(col, _scale.HorizontalAlignment);
                                _scale.Draw(spriteBatch);
                                //_scale.Y = GetY(lig * 3 + 1);
                                //_scale.Draw(sb);
                                break;
                            case GridItem.Hole1:
                            case GridItem.Monster1:
                                if (col >= nextHole)
                                {
                                    nextHole = col + 6;
                                    _hole.TextureIndex = 0;
                                    _hole.Y = GetY(lig * 3);
                                    _hole.X = GetX(col, _hole.HorizontalAlignment);
                                    _hole.Draw(spriteBatch);
                                }
                                break;
                            case GridItem.Hole2:
                            case GridItem.Monster2:
                                if (col >= nextHole)
                                {
                                    nextHole = col + 6;
                                    _hole.TextureIndex = 1;
                                    _hole.Y = GetY(lig * 3);
                                    _hole.X = GetX(col, _hole.HorizontalAlignment);
                                    _hole.Draw(spriteBatch);
                                }
                                break;
                            case GridItem.Hole3:
                            case GridItem.Monster3:
                                if (col >= nextHole)
                                {
                                    nextHole = col + 6;
                                    _hole.TextureIndex = 2;
                                    _hole.Y = GetY(lig * 3);
                                    _hole.X = GetX(col, _hole.HorizontalAlignment);
                                    _hole.Draw(spriteBatch);
                                }
                                break;
                        }
                    }
                }
            }
        }

        public int GetX(int column, SpriteHorizontalAlignment align)
        {
            return Constants.MarginLeft + column * Constants.CellWidth + _deltas[(int)align];
        }
        public int GetY(int line)
        {
            return Constants.MarginTop + (Constants.PhysicalHeight - line) * Constants.CellHeight;
        }

        public void LoadGridItems(string[] definition)
        {
            GridItem newItem;
            string line = null;
            for (int lig = 0; lig < 6; lig++)
            {
                line = definition[lig];
                int logLig = 4 * (5 - lig);
                for (int c = 0; c < line.Length; c++)
                {
                    int col = c * 3;
                    switch (line[c])
                    {
                        case 'B':
                            // Brick : nothing special, fill all cells
                            newItem = (logLig == 0 ? GridItem.Ground : GridItem.Brick);
                            for (int i = 0; i < 3; i++)
                            {
                                _items[col + i, logLig] = newItem;
                                _items[col + i, logLig + 1] = GridItem.Empty;
                                _items[col + i, logLig + 2] = GridItem.Empty;
                                _items[col + i, logLig + 3] = GridItem.Empty;
                            }
                            break;
#if TESTHOLE
                        case 'H':
                            // Hole... just for testing
                            _items[col, logLig] = GridItem.Hole1;
                            break;
#endif
                        case 'S':
                            newItem = (logLig == 0 ? GridItem.Ground : GridItem.Brick);
                            _items[col + 0, logLig] = newItem;
                            _items[col + 1, logLig] = GridItem.Scale;
                            _items[col + 2, logLig] = newItem;

                            _items[col + 0, logLig + 1] = GridItem.Empty;
                            _items[col + 1, logLig + 1] = GridItem.Scale;
                            _items[col + 2, logLig + 1] = GridItem.Empty;


                            _items[col + 0, logLig + 2] = GridItem.Empty;
                            _items[col + 0, logLig + 3] = GridItem.Empty;
                            if ((lig > 0) && (_items[col + 1, logLig + 4] == GridItem.Scale))
                            {
                                _items[col + 1, logLig + 2] = GridItem.Scale;
                                _items[col + 1, logLig + 3] = GridItem.Scale;
                            }
                            else
                            {
                                _items[col + 1, logLig + 2] = GridItem.Empty;
                                _items[col + 1, logLig + 3] = GridItem.Empty;
                            }
                            _items[col + 2, logLig + 2] = GridItem.Empty;
                            _items[col + 2, logLig + 3] = GridItem.Empty;
                            break;
                    }
                }
            }
        } // LoadGridITem


/*        int lastLogX = -1;
        int lastPhysY = -1;
        int lastDirX = -1;
        */

        public bool CanDig(int logX, int physY, int dirX)
        {
            bool trace = false;
#if false
            if ((logX != lastLogX) || (physY != lastPhysY) || (dirX != lastDirX))
            {
                trace = true;
                lastLogX = logX;
                lastPhysY = physY;
                lastDirX = dirX;
            }
#endif
            if (trace)
            {
                Debug.WriteLine("CanDig ? x=" + logX.ToString() + ", y=" + physY.ToString() + ", dir=" + dirX.ToString());
            }
            if (physY % 3 != 0) return false;
            int logY = physY / 3;
            GridItem item = _items[logX, logY];
            int endX = logX + 7 * dirX;
            if ((endX < 0) || (endX >= Constants.Width)) return false;
            endX += dirX;
            if ((endX >= 0) && (endX < Constants.Width))
            {
                item = _items[endX, logY];
                if (trace) {
                    Debug.WriteLine("Item derrire trou = " + item.ToString());
                }
                if (item != GridItem.Brick) return false;
            }
            logX += dirX;
            item = _items[logX, logY];
            if (trace)
            {
                Debug.WriteLine("item ddevant = " + item.ToString());
            }
            if (item != GridItem.Brick) return false;
            logX += dirX;
            item = _items[logX, logY];
            if (trace)
            {
                Debug.WriteLine("1er item trou = " + item.ToString());
            }
            if ((item != GridItem.Brick) && (item != GridItem.Hole1) && (item != GridItem.Hole2)) return false;
            for (int i = 0; i < 5; i++)
            {
                logX += dirX;
                if (trace)
                {
                    Debug.WriteLine("item #" + (i + 1).ToString() + " = " + _items[logX, logY].ToString());
                }
                if (_items[logX, logY] != item) return false;
            }
            if (trace)
            {
                Debug.WriteLine("Peut creuser");
            }
            return true;
        }
        public bool CanFill(int logX, int physY, int dirX)
        {
            bool trace = false;
#if false
            if ((logX != lastLogX) || (physY != lastPhysY) || (dirX != lastDirX))
            {
                trace = true;
                lastLogX = logX;
                lastPhysY = physY;
                lastDirX = dirX;
            }
#endif
            if (trace)
            {
                Debug.WriteLine("CanFill ? x=" + logX.ToString() + ", y=" + physY.ToString() + ", dir=" + dirX.ToString());
            }
            if (physY % 3 != 0) return false;
            int logY = physY / 3;
            GridItem item = _items[logX, logY];
            int endX = logX + 7 * dirX;
            if ((endX < 0) || (endX >= Constants.Width)) return false;
            endX += dirX;
            if ((endX >= 0) && (endX < Constants.Width))
            {
                item = _items[endX, logY];
                if (trace)
                {
                    Debug.WriteLine("Item derrire trou = " + item.ToString());
                }
                if (item != GridItem.Brick) return false;
            }
            logX += dirX;
            item = _items[logX, logY];
            if (trace)
            {
                Debug.WriteLine("item ddevant = " + item.ToString());
            }
            if (item != GridItem.Brick) return false;
            logX += dirX;
            item = _items[logX, logY];
            if (trace)
            {
                Debug.WriteLine("1er item trou = " + item.ToString());
            }
            if ((item != GridItem.Monster1) && (item != GridItem.Monster2) && (item != GridItem.Monster3)
                && (item != GridItem.Hole3) && (item != GridItem.Hole1) && (item != GridItem.Hole2)) return false;
            for (int i = 0; i < 5; i++)
            {
                logX += dirX;
                if (trace)
                {
                    Debug.WriteLine("item #" + (i + 1).ToString() + " = " + _items[logX, logY].ToString());
                }
                if (_items[logX, logY] != item) return false;
            }
            if (trace)
            {
                Debug.WriteLine("Peut creuser");
            }
            return true;
        }

        private int FindHoleBeginning(int logX, int logY)
        {
            int x = 0;
            while (x < Constants.Width)
            {
                switch (_items[x, logY])
                {
                    case GridItem.Hole1:
                    case GridItem.Hole2:
                    case GridItem.Hole3:
                    case GridItem.Monster1:
                    case GridItem.Monster2:
                    case GridItem.Monster3:
                    case GridItem.MonsterLeaving:
                        if (x + 6 > logX)
                        {
                            return x;
                        }
                        else
                        {
                            x += 6;
                        }
                        break;
                    default:
                        x++;
                        break;
                }
            }
            return Constants.Width;
        }
        public bool IsInHole(int logX, int physY)
        {
            int logY = physY / 3;
            GridItem item = _items[logX, logY];
            return /*(item == GridItem.Hole1) || (item == GridItem.Hole2) ||*/ (item == GridItem.Hole3);
        }

        public int GetHolePos(int logX, int physY)
        {
            int logY = physY / 3;
            int minX = FindHoleBeginning(logX, logY);
            return minX + 2;
        }

        public int SetMonsterInHole(int logX, int physY, Monster monster)
        {
            int logY = physY / 3;
            int minX = FindHoleBeginning(logX, logY);

            for (int i = 0; i < 6;i++) 
            {
                _items[minX + i, logY] = (monster == null) ? GridItem.MonsterLeaving : GridItem.Monster3;
            }

            Debug.WriteLine("Monsters[" + minX.ToString() + "," + logY.ToString() + "] = " + (monster != null).ToString());
            _monsters[minX, logY] = monster;
            return minX + 2;
        }

        public void FillHole(int logX, int physY)
        {
            int logY = physY / 3;
            int minX = FindHoleBeginning(logX, logY);
            if ((minX >= 0) && (minX <= Constants.Width - 6))
            {
                for (int i = 0; i < 6; i++)
                {
                    _items[minX + i, logY] = GridItem.Brick;
                }
            }
        }
        public void Dig(int logX, int physY, int dirX, bool digging)
        {
            int logY = physY / 3;
            logX += 2 * dirX;
            GridItem nouv = _items[logX, logY];
            switch (nouv)
            {
                case GridItem.Brick:
                    if (digging)
                    {
                        nouv = GridItem.Hole1;
                    }
                    break;
                case GridItem.Hole1:
                    if (digging)
                    {
                        nouv = GridItem.Hole2;
                    }
                    else
                    {
                        nouv = GridItem.Brick;
                    }
                    break;
                case GridItem.Hole2:
                    if (digging)
                    {
                        nouv = GridItem.Hole3;
                    }
                    else
                    {
                        nouv = GridItem.Hole1;
                    }
                    break;
                case GridItem.Hole3:
                    if (!digging)
                    {
                        nouv = GridItem.Hole2;
                    }
                    break;
                case GridItem.Monster1:
                    if (!digging)
                    {
                        int minX = FindHoleBeginning(logX, logY);
                        Monster monster = _monsters[minX, logY];
                        if (monster != null)
                        {
                            nouv = GridItem.Brick;
                            _monsters[minX, logY] = null;
                            monster.Fall();
                        }
                    }
                    break;
                case GridItem.Monster2:
                    if (!digging)
                    {
                        nouv = GridItem.Monster1;
                        int minX = FindHoleBeginning(logX, logY);
                        Monster monster = _monsters[minX, logY];
                        if (monster != null)
                        {
                            monster.ResetHoleLoop();
                        }
                    }
                    break;
                case GridItem.Monster3:
                    if (!digging) {
                        nouv = GridItem.Monster2;
                        int minX = FindHoleBeginning(logX, logY);
                        Monster monster = _monsters[minX, logY];
                        if (monster != null)
                        {
                            monster.ResetHoleLoop();
                        }
                    }
                    break;
            }
            if (_items[logX, logY] != nouv)
            {
                // Changing
                _soundService.PlaySound(digging ? Sound.Dig : Sound.Fill);
                for (int i = 0; i < 6; i++)
                {
                    _items[logX, logY] = nouv;
                    logX += dirX;
                }
            }
        }

        public bool CanGo(int logX, int physY, int dirX, int dirY, bool fillHoles)
        {
            int logY = physY / 3;

            int newX, newY;
            if (dirY == 0) {
                if (physY % 3 != 0) return false;
                newX = (logX + dirX);
                if ((newX <= 0) || (newX >= Constants.Width)) return false;
                //newX /= 4;
                // new square
                GridItem target = _items[newX, logY];
                if (fillHoles)
                {
                    return target != GridItem.Empty;
                }
                else
                {
                    // Can go if 
                    // 1. next square is correct
                    // 2. and following is not a partial hole
                    if ((target != GridItem.Hole3) && (target != GridItem.Ground) && (target != GridItem.Brick) && (target != GridItem.Scale)) return false;
                    newX += dirX;
                    if ((newX <= 0) || (newX >= Constants.Width)) return true;
                    target = _items[newX, logY];
                    return ((target != GridItem.Hole1) && (target != GridItem.Hole2)
                        && (target != GridItem.Monster1) && (target != GridItem.Monster2) && (target != GridItem.Monster3) && (target != GridItem.MonsterLeaving));
                }
            } else {
                newY = (physY + dirY);
                if ((newY < 0) || (newY >= Constants.PhysicalHeight - 6)) return false;
                newY /= 3;
                if ((physY % 3 != 0) && (logY == newY))
                {
                    // same logical square
                    return _items[logX, logY] == GridItem.Scale;
                }
                else
                {
                    // new square
                    if ((dirY == 1) && (_items[logX, logY + 2] != GridItem.Scale)) return false;
                    return _items[logX, newY] == GridItem.Scale;
                }
            }
        }

        public bool IsCrossing(int logX, int physY)
        {
            if (physY % 3 != 0) return false;

            int logY = physY / 3;

            return (logY % 4 == 0) && (_items[logX, logY] == GridItem.Scale);
        }

        public bool EndFall(int logX, int physY)
        {
            if (physY % 12 != 0) return false;
            int logY = physY / 3;
            GridItem item = _items[logX, logY];
            bool ret = true;
            switch (item)
            {
                case GridItem.Empty:
                    ret = false;
                    break;
                case GridItem.Hole3:
                    int holeStart = FindHoleBeginning(logX, logY);
                    Debug.WriteLine("EndFall : x=" + logX.ToString() + ", hole=" + holeStart.ToString());
                    ret = holeStart + 2 != logX;
                    break;
            }
            Debug.WriteLine("EndFall(" + item.ToString() + ") = " + ret.ToString());
            return ret;
        }

        public void FillPartialHole(int logX, int physY)
        {
            if (physY % 12 != 0) return;
            int logY = physY / 3;
            GridItem item = _items[logX, logY];
            if ((item == GridItem.Hole1) || (item == GridItem.Hole2))
            {
                int minX = FindHoleBeginning(logX, logY);
                for (int i = 0; i < 6; i++)
                {
                    _items[minX + i, logY] = GridItem.Brick;
                }
            }
        }
    } // class Grid
} // namespace