using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Resources;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace XnaPanic
{
    public enum SpriteHorizontalAlignment : int { Left = 0, Center = 1, Right = 2};
    public enum SpriteVerticalAlignment { Top, Center, Bottom };

    public partial class MultiTextureSprite 
    {
        protected Rectangle _rectangle;
        protected int _textureIndex;
        Texture2D[] _textures;
        private int _x;
        private int _y;
        private SpriteHorizontalAlignment _horzAlignment;
        private SpriteVerticalAlignment _vertAligment;
        private int _offsetX;

        public int OffsetX
        {
            get { return _offsetX; }
            set { _offsetX = value; }
        }
        private int _offsetY;

        public int OffsetY
        {
            get { return _offsetY; }
            set { _offsetY = value; }
        }

        public SpriteVerticalAlignment VerticalAlignment
        {
            get { return _vertAligment; }
            set { _vertAligment = value; ComputePos(); }
        }

        public SpriteHorizontalAlignment HorizontalAlignment
        {
            get { return _horzAlignment; }
            set { _horzAlignment = value; ComputePos(); }
        }

        public int X
        {
            get { return _x; }
            set { _x = value; ComputePos(); }
        }
        public int Y
        {
            get { return _rectangle.Y; }
            set { _y = value; ComputePos(); }
        }
        public int Width
        {
            get
            {
                return _rectangle.Width;
            }
        }
        public int Height
        {
            get
            {
                return _rectangle.Height;
            }
        }
        public int TextureIndex
        {
            get { return _textureIndex; }
            set { _textureIndex = value; ComputePos();}
        }

        public void IncrementTexture()
        {
            if (++_textureIndex == _textures.Length)
            {
                _textureIndex = 0;
                ComputePos();
            }
        }

        public MultiTextureSprite()
        {
            _rectangle = new Rectangle(0, 0, 0, 0);
        }

        public MultiTextureSprite(SpriteHorizontalAlignment horzAlign, SpriteVerticalAlignment vertAlign, ContentManager content, string folder, params object[] resources) {
            if (resources.Length == 0)
            {
                throw new InvalidOperationException("Sprite needs 2D Resources");
            }
            _horzAlignment = horzAlign;
            _vertAligment = vertAlign;
            _rectangle = new Rectangle(0, 0, 0, 0);
            _textures = new Texture2D[resources.Length];
            for (int i = 0; i < resources.Length; i++)
            {
                _textures[i] = content.Load<Texture2D>(folder + @"\" + (string)resources[i]);
            }
            _rectangle.Width = _textures[0].Width;
            _rectangle.Height = _textures[0].Height;
            _textureIndex = 0;
            ComputePos();
        }

        public static bool TraceRectangle = false;
        public void Draw(SpriteBatch sb)
        {
            sb.Draw(_textures[_textureIndex], _rectangle, Color.White);
        }

        protected void ComputePos()
        {
            if ((_textures != null) && (_textures[_textureIndex] != null)) {
                _rectangle.Width = _textures[_textureIndex].Width;
                _rectangle.Height = _textures[_textureIndex].Height;
            }
            switch (_horzAlignment) {
            case SpriteHorizontalAlignment.Left:
                _rectangle.X = _x;
                break;
            case SpriteHorizontalAlignment.Center:
                _rectangle.X = _x - (_rectangle.Width / 2);
                break;
            case SpriteHorizontalAlignment.Right:
                _rectangle.X = _x - _rectangle.Width;
                break;
            }
            switch (_vertAligment) {
            case SpriteVerticalAlignment.Top:
                _rectangle.Y = _y;
                break;
            case SpriteVerticalAlignment.Center:
                _rectangle.Y = _y - (_rectangle.Height / 2);
                break;
            case SpriteVerticalAlignment.Bottom:
                _rectangle.Y = _y - _rectangle.Height;
                break;
            }
            if (_offsetX != 0) _rectangle.X += _offsetX;
            if (_offsetY != 0) _rectangle.Y += _offsetY;
        }
    }
}