using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace XnaPanic
{
    class NumberTracer : INumberTracerService
    {
        #region Private Fields
        private Texture2D _labelTexture;
        private int _width;
        private int _height;
        #endregion

        #region Properties
        int INumberTracerService.Width
        {
            get
            {
                return _width;
            }
        }
        #endregion

        #region Construction
        public NumberTracer()
        {
        }
        #endregion

        #region Initialization
        public void LoadGraphicsContent(ContentManager content)
        {
            _labelTexture = content.Load<Texture2D>(@"Sprites\Game\Font");
            _width = _labelTexture.Width / 10;
            _height = _labelTexture.Height;
        }
        #endregion

        #region Methods
        void INumberTracerService.Draw(SpriteBatch sb, int number, int left, int top, int digitCount)
        {
            Rectangle sourceRect = new Rectangle(0, 0, _width, _height);
            Rectangle destRect = new Rectangle(left + digitCount * _width, top, _width, _height);
            for (int i = 0; i < digitCount; i++)
            {
                int value = number % 10;
                number = number / 10;
                destRect.X -= _width;
                sourceRect.X = value * _width;
                sb.Draw(_labelTexture, destRect, sourceRect, Color.White);
            }
        }
        #endregion

    }
}
