using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;


namespace XnaPanic
{

    public class SoundManager : ISoundService
    {
        AudioEngine _AudioEngine;
        WaveBank _WaveBank;
        SoundBank _SoundBank;

        public void LoadSounds()
        {
            _AudioEngine = new AudioEngine(@"Sounds\XnaPanic.xgs");
            _WaveBank = new WaveBank(_AudioEngine, @"Sounds\Wave Bank.xwb");
            _SoundBank = new SoundBank(_AudioEngine, @"Sounds\Sound Bank.xsb");
        }

        public void Update()
        {
            _AudioEngine.Update();
        }

        Cue ISoundService.PlaySound(Sound sound)
        {
            Cue cue = _SoundBank.GetCue(sound.ToString());
            cue.Play();
            return cue;
        }

    }
}
