
package sanspattern;

import java.util.Vector;

enum TypeEntite {
    TYPESOLDAT, 
    TYPETANK, 
}

class Entite {
    protected String categorie;
    protected int pv; // Points de vie
    
    Entite() {
        init();
    }
    
    public void init() {
        categorie = "Entite";
        pv = 0;
    }
    
    public void display() {
        System.out.println(categorie + ", pv: " + pv);
    }
    
    public void action() {}
}

class Soldat extends Entite {
    Soldat() {
        init();
    }
    @Override
    public void init() {
        categorie = "Soldat";
        pv = 10;
    }
    @Override
    public void display() {
        System.out.println(categorie + ", pv: " + pv);
    }
    
    @Override
    public void action() {
        System.out.println("Action soldatesque");
    }
}

class Tank extends Entite {
    Tank() {
        init();
    }
    @Override
    public void init() {
        categorie = "Tank";
        pv = 500;
    }
    @Override
    public void display() {
        System.out.println(categorie + ", pv: " + pv);
    }
    
    @Override
    public void action() {
        System.out.println("Action blindee");
    }
}


class PanneauJeu {
    Vector<Entite> pieces = new Vector<Entite>();
   
    public void creerEntite(TypeEntite type) {
        switch(type) {
            case TYPESOLDAT:
                pieces.add(new Soldat());
                break;
            case TYPETANK:
                pieces.add(new Tank());
                break;
            default:
                break;
        }
    }
    
    public void jouer() {
        for(Entite e : pieces) {
            e.display();
            e.action();
        }
    }
}
public class JeuBasic {
    public static void main(String[] args) {
        PanneauJeu pj = new PanneauJeu();
        // Ici le joueur clique sur l'interface
        // et crée des entités
        pj.creerEntite(TypeEntite.TYPESOLDAT);
        pj.creerEntite(TypeEntite.TYPETANK);
        // puis le jeu se déroule
        pj.jouer();
        // et ainsi de suite
    }
} 
