#ifndef INOTIFYWATCHER_HPP_
#define INOTIFYWATCHER_HPP_


#include <unistd.h>
#include <fcntl.h>
#include <sys/inotify.h>

#include <string>
#include <sstream>
#include <cstring>

#include <boost/thread/thread.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/ref.hpp>
#include <boost/bind.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/scoped_array.hpp>

class INotifyWatcher
{
public:
	INotifyWatcher(std::string inode,
		int fd, unsigned int events);
	~INotifyWatcher();
private:
	void worker();
	void destroy_fd();
	static std::string mask2text(unsigned int);

	std::string inode;
	int fd_tube_in;
	size_t buffer_size;
	volatile int fd_inotify;
	volatile int fd_watch;
	volatile bool fini;
	
	static const size_t event_size =
		sizeof (struct inotify_event);
	static const size_t one_buffer_size =
		event_size + 32;
		
	static const char* alloc_error_msg;
	static const char* error_msg;
	static const char* unmount_error_msg;
	
	boost::scoped_ptr<boost::thread> thread;
	boost::scoped_array<char> buffer;
	boost::try_mutex tmtx;
	
	INotifyWatcher(const INotifyWatcher&);
	INotifyWatcher& operator=(const INotifyWatcher&);
};

#endif /* INOTIFYWATCHER_HPP_ */

