#include <iostream>

#include <unistd.h>
#include <fcntl.h>

#include "inotifywatcher.hpp"

int tube[2];
volatile bool app_worker_fini = false;

void app_worker()
{
	// Passer en lecture non-bloquante
	// du ct 'sortie' du tube
	fcntl(tube[0], F_SETFL,
		fcntl(tube[0], F_GETFL) | O_NONBLOCK);

	char c;
	int len_read;
	// flag, uniquement pour soigner un peu
	// l'affichage
	bool flag = false;

	while(!app_worker_fini)
	{		
		len_read = read(tube[0], &c, 1); 
		if(len_read == 1)
		{
			if(!flag)
			{
				write(STDOUT_FILENO, "\n", 1);
				flag = true;
			}
			write(STDOUT_FILENO, &c, 1);
		}
		else
		{
			flag = false;
			write(STDOUT_FILENO, ".", 1);
			usleep(300000);
		}
	}
}

int main(int argc, char** argv)
{
	boost::scoped_ptr<INotifyWatcher> inw;
	
	std::cout.sync_with_stdio(false);
	
	if(argc != 2)
	{
		std::cout << "Donnez le nom d'un rpertoire ou d'un"
					" fichier  surveiller" << std::endl;
		std::cout << "Exemple: ./DemoINotify /home/fred" << std::endl;
		exit(EXIT_FAILURE); 
	}
	
	if(pipe(tube) == -1)
	{
		std::cout << "Impossible d'ouvrir le tube de "
					 "communication -- arrt" << std::endl;
	}
	
	try
	{
		inw.reset(new INotifyWatcher(argv[1],
					tube[1], IN_ALL_EVENTS));
	}
	catch(int e)
	{
		switch(e)
		{
			case 1:
				std::cout << "Impossible d'initialiser"
					" INotify -- Arrt" << std::endl;  
				break;
			case 2:
				std::cout << "Impossible d'ajouter le "
					"point de surveillance"
					" INotify -- Arrt" << std::endl;  
			
				break;
			default:
				std::cout << "Problme inconnu -- Arrt"
					<< std::endl;
				break;
		}
		close(tube[0]);
		close(tube[1]);
		exit(EXIT_FAILURE);
	}
	
	std::cout << "Application lance -- Appuyez sur"
				 " [return] pour arrter" << std::endl;
	
	boost::thread t(app_worker);
	std::cin.get();
	inw.reset();
	app_worker_fini = true;
	t.join();
	close(tube[0]);
	close(tube[1]);
	return EXIT_SUCCESS;
}
